#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputDataFile\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Optional  :OutputDataFile(2D)\n");
    fprintf(stderr, "    [-O[utput]           Out3D               (NULL      )] :Optional  :OutputDataFile(3D)\n");
    fprintf(stderr, "    [-d[elta]            dx                  (5.0       )dy                  (5.0       )] :Essential :delta: dx[A] dy[A]\n");
    fprintf(stderr, "    [-s[tart]            sx                  (0.0       )sy                  (0.0       )] :Optional  :start: startx[A] starty[A]: When -s was not set, image centre is the origin(0,0,0)\n");
    fprintf(stderr, "    [-n[umber]           nx                  (0         )ny                  (0         )] :Essential :N:     nx ny (image size)\n");
    fprintf(stderr, "    [-Rot[ation]         rotnx               (1         )rotny               (1         )] :Optional  :rotnx rotny\n");
    fprintf(stderr, "    [-S[tart]            srotx               (0.0       )sroty               (0.0       )srotz               (0.0       )] :Optional  :start(rotx roty rotz):ZXY\n");
    fprintf(stderr, "    [-startE[uler]A[ngle]sRotMode            (YOYS      )sRot1               (0.0       )sRot2               (0.0       )sRot3               (0.0       )] :Optional  :EulerAngle: Start Angle\n");
    fprintf(stderr, "    [-E[uler]A[ngle]Mode RotMode             (YOYS      )] :Optional  :RotationMode\n");
    fprintf(stderr, "    [-E[uler]A[ngle]Rot1 dRot1               (5.0       )minRot1             (0.0       )maxRot1             (180.0     )] :Optional  :FirstRotation\n");
    fprintf(stderr, "    [-E[uler]A[ngle]Rot2 dRot2               (5.0       )minRot2             (0.0       )maxRot2             (180.0     )] :Optional  :SecondRotation\n");
    fprintf(stderr, "    [-w[eight]           Weight              (1.0       )] :Optional  :weight\n");
    fprintf(stderr, "    [-sig[ma]            Sigma               (0.0       )] :Optional  :Sigma[A]:Atom radius\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode: 0 Merc; 1: Earth\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
