#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-I[nputList]        In                  (NULL      )] :Essential :InputDataFileList\n");
    fprintf(stderr, "    [-o[utput]H[eader]   OutHeader           (test      )] :Optional  :OutputDataFileHeader\n");
    fprintf(stderr, "    [-R[sults]d[irectoryname]Rd                  (Result    )] :Optional  :output results directory name\n");
    fprintf(stderr, "    [-N[ormalCorrelation]d[irectoryname]Nd                  (Normal    )] :Optional  :directory name of output normalcorrelation in results directory\n");
    fprintf(stderr, "    [-D[erivation]1[DCorrelation]d[irectoryname]D1d                 (Derivation1D)] :Optional  :directory name of output derivation1Dcorrelation in results directory\n");
    fprintf(stderr, "    [-D[erivation]2[DCorrelation]d[irectoryname]D2d                 (Derivation2D)] :Optional  :directory name of output derivation2Dcorrelation in results directory\n");
    fprintf(stderr, "    [-L[engthCorrelation]d[irectoryname]Ld                  (Length    )] :Optional  :directory name of output lengthcorrelation in results directory\n");
    fprintf(stderr, "    [-C[orrelation]E[xtension]CorrelationExtension(cor       )] :Optional  :output correlation file extension\n");
    fprintf(stderr, "    [-L[ist]E[xtension]  ListExtension       (list      )] :Optional  :output file list extension\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    fprintf(stderr, "    [-N[ormalCorrelation]m[ode]Nmode               (0         )] :Optional  :\n");
    fprintf(stderr, "    [-D[erivation]1[DCorrelation]m[ode]D1mode              (0         )] :Optional  :\n");
    fprintf(stderr, "    [-D[erivation]2[DCorrelation]m[ode]D2mode              (0         )] :Optional  :\n");
    fprintf(stderr, "    [-L[engthCorrelation]m[ode]Lmode               (0         )] :Optional  :\n");
    fprintf(stderr, "    [-L[ength]T[hreshold]M[ode]LengthThresholdMode (0         )] :Optional  :LengthThresholdMode\n");
    fprintf(stderr, "    [-L[ength]T[hreshold]M[ode]LengthThresholdRatio(0.25      )] :Optional  :LengthThresholdRatio\n");
    fprintf(stderr, "    [-C[reate]M[ode]     CM                  (0         )] :Optional  :CreateMode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
