#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputDataFile\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-r[oi]              roiLine             (NULL      )... ] :Variable  :\n");
    fprintf(stderr, "    [-x                  x                   (1.0       )] :Essential :Width :Source \n");
    fprintf(stderr, "    [-y                  y                   (1.0       )] :Optional  :Height:Source\n");
    fprintf(stderr, "    [-W                  Width               (1.0       )] :Optional  :Width :Dst \n");
    fprintf(stderr, "    [-H                  Height              (1.0       )] :Optional  :Height:Dst \n");
    fprintf(stderr, "    [-cor                Cor                 (360.0     )] :Optional  :Correlation Window along Y-axis [A]\n");
    fprintf(stderr, "    [-S[hrink]           Shrink              (1         )] :Optional  :When inputfile is shrinked:\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
