#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputDataFile\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-dr                 dr                  (1         )] :Optional  :Delta r of outputfile[A].\n");
    fprintf(stderr, "    [-dtheta             dtheta              (1         )] :Optional  :Delta theta of outputfile.[degree]\n");
    fprintf(stderr, "    [-dphi               dphi                (1         )] :Optional  :Delta phi of outputfile.[degree]\n");
    fprintf(stderr, "    [-zaxis              zx                  (0         )zy                  (0         )zz                  (1         )] :Optional  :vector of z-axis\n");
    fprintf(stderr, "    [-xaxis              xx                  (1         )xy                  (0         )xz                  (0         )] :Optional  :vector of x-axis\n");
    fprintf(stderr, "    [-centre             cx                  (0         )cy                  (0         )cz                  (0         )] :Optional  :centre of image\n");
    fprintf(stderr, "    [-rweight            ] :Optional  :r-weighted\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
