#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-I[nput]            InList              (NULL      )] :Essential :Input:ImageFileList\n");
    fprintf(stderr, "    [-o[utput]1d         Out1D               (NULL      )] :Optional  :Output:\n");
    fprintf(stderr, "    [-o[utput]1de[nlarged]Out1DEnlarged       (NULL      )] :Optional  :Output:\n");
    fprintf(stderr, "    [-o[utput]2d         Out2D               (NULL      )] :Optional  :Output:\n");
    fprintf(stderr, "    [-a[xis]P[osition]   OriginX             (0.0       )OriginY             (0.0       )OriginZ             (0.0       )] :Optional  :Input: AxisPosition\n");
    fprintf(stderr, "    [-a[xisAngle]        AxisAngleYaw        (0.0       )AxisAnglePitch      (0.0       )] :Optional  :Input: AxisAngleYaw/Pitch[degree]\n");
    fprintf(stderr, "    [-R                  Rmin                (0.05      )Rmax                (0.1       )] :Optional  :Input: LowPathFiltering\n");
    fprintf(stderr, "    [-Interp[olationMode]InterpolationMode   (2         )] :Optional  :Input: InterpolationMode\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
