#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Optional  :In: MRC\n");
    fprintf(stderr, "    [-I[nput]            InList              (NULL      )] :Optional  :In: MRC\n");
    fprintf(stderr, "    [-r[ef]              Ref                 (NULL      )] :Essential :Ref: MRC\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Essential :Output: Correlation\n");
    fprintf(stderr, "    [-O[utput]           Out2                (stdout    )] :Optional  :Output: Estimated\n");
    fprintf(stderr, "    [-range              thetaMin            (-90       )thetaMax            (+90       )thetaDelta          (1         )] :Optional  :Search Range [degree]\n");
    fprintf(stderr, "    [-w[idth]            Width               (0.5       )] :Optional  :Projection Range[MIn(Nx,Ny)*Width] around centre\n");
    fprintf(stderr, "    [-M[ode]             Mode                (2         )] :Optional  :Interpolation Mode\n");
    fprintf(stderr, "    [-C[orrelation]M[ode]CorrelationMode     (17        )] :Optional  :Correlation Mode\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
