/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% mrcImageNoiseCreate ver %I%
#%Z% Created by 
#%Z%
#%Z% Usage : mrcImageNoiseCreate
#%Z% Attention
#%Z%
*/
static char __sccs_id[] = "%Z%mrcImageNoiseCreate ver%I%; Date:%D% %Z%";
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>                  
#define GLOBAL_DECLARATION
#include "../inc/config.h"

#define DEBUG
#include "genUtil.h"
#include "mrcImage.h"
#include "mrcRefUtil.h" 
#include "Random.h"


/* prototype */
void lmrcImageNoiseCreate(mrcImage* out ,mrcImage* in ,float Noise);

void
main(int argc, char* argv[]) 
{
	mrcImageNoiseCreateInfo info;

/* variables */
	mrcImage in;
	mrcImage out;

/* input patameters ,file open */
	init0(&info);
	argCheck(&info, argc, argv);
	init1(&info);

/* begin */
	mrcFileRead(&in ,info.In ,"in main" ,0);
	DEBUGPRINT("Program Start\n");
	lmrcImageNoiseCreate(&out ,&in ,info.Noise);
	mrcFileWrite(&out ,info.Out ,"in main" ,0);
	exit(EXIT_SUCCESS);
}

void
additionalUsage()
{
	fprintf(stderr, "----- Additional Usage -----\n");
	fprintf(stderr, "Output file has the same infomation (Nx Ny Nz Length and so on) as reference file. \n");
}

void lmrcImageNoiseCreate(mrcImage* out ,mrcImage* in ,float Noise)
{
/* variables */
  int x,y,z;
  double data;
  
/* begin */
  lRandShuffle();
  out->Header = in->Header;
  mrcInit(out,0);
  for (z=0 ;z<in->HeaderN.z ;z++){
    for (y=0 ;y<in->HeaderN.y ;y++){
      for (x=0 ;x<in->HeaderN.x ;x++){
	data = randomNormalGet(0)*Noise;
	mrcPixelDataSet(out ,x ,y ,z ,data  ,mrcPixelRePart);
      }
    }
  }
  mrcStatDataSet(out,0);
}
  
