#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :Test: Input\n");
    fprintf(stderr, "    [-r[ef]              Ref                 (NULL      )] :Essential :Reference: Input\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Essential :NormalizedImage:  Output\n");
    fprintf(stderr, "    [-O[utput]           OutParam            (stdout    )] :Optional  :Parameters:       Output\n");
    fprintf(stderr, "    [-D[ataForNormalizing]UsedData            (stdout    )] :Optional  :DataList to be used\n");
    fprintf(stderr, "    [-Cylinder           CCenterX            (20        )CCenterY            (20        )CMinR               (10        )CMaxR               (20        )] :Optional  :Cylinder Region\n");
    fprintf(stderr, "    [-testBG[Region]     tstBGMin            (-3        )tstBGMax            (3         )tstBGDelta          (0.1       )] :Optional  :SearchRegion\n");
    fprintf(stderr, "    [-M[ode]             fitMode             (0         )] :Optional  :DensityFittngMethod: Mode\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
