#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "../inc/config.h"
#include "genUtil.h"
#include "String.h"
#include "File.h"
#include "Memory.h"


void
argCheck(mrcImageAutoFilamentExtractInfo* info, int argc, char* argv[])
{
    long i, j, nv;
    char s[1024];
    for(i=1; i<argc; i++) {
        if(OPTION_FLAG==argv[i][OPTION_FLAG_POS]) {
            SSWITCH(argv[i]+OPTION_POS)
                SCASE("i") {
                    if(i+1<argc) {
                        info->In = stringGetNthWord(argv[i+1], 1, " ,");
                        i++;
                        info->flagIn++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("iS") {
                    if(i+1<argc) {
                        info->InS = stringGetNthWord(argv[i+1], 1, " ,");
                        i++;
                        info->flagInS++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("oE") {
                    if(i+1<argc) {
                        info->OutE = stringGetNthWord(argv[i+1], 1, " ,");
                        i++;
                        info->flagOutE++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("o") {
                    if(i+1<argc) {
                        info->Out = stringGetNthWord(argv[i+1], 1, " ,");
                        i++;
                        info->flagOut++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("oF") {
                    if(i+1<argc) {
                        info->OutF = stringGetNthWord(argv[i+1], 1, " ,");
                        i++;
                        info->flagOutF++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("rROI") {
                    if(i+8<argc) {
                        info->blx = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagblx++;
                        info->bly = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagbly++;
                        info->brx = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagbrx++;
                        info->bry = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagbry++;
                        info->trx = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagtrx++;
                        info->try = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagtry++;
                        info->tlx = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagtlx++;
                        info->tly = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagtly++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("rUnbent") {
                    if(i+1<argc) {
                        nv = argc - i - 1;
                        info->roiLine = (float*)memoryAllocate(sizeof(float)*nv, "in argCheck");
                        for(j=0; j<nv; j++) {
                            info->roiLine[j] = stringGetNthRealData(argv[i+j+1], 1, " ,");
                        }
                        info->flagroiLine=nv;
                        i+=nv;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("x") {
                    if(i+1<argc) {
                        info->x = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagx++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("ddYmax") {
                    if(i+1<argc) {
                        info->ddYmax = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagddYmax++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("ddYmin") {
                    if(i+1<argc) {
                        info->ddYmin = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagddYmin++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("T") {
                    if(i+1<argc) {
                        info->T = stringGetNthIntegerData(argv[i+1], 1, " ,");
                        i++;
                        info->flagT++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("maxdY") {
                    if(i+1<argc) {
                        info->maxdY = stringGetNthIntegerData(argv[i+1], 1, " ,");
                        i++;
                        info->flagmaxdY++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("HR") {
                    if(i+1<argc) {
                        info->HeightRange = stringGetNthIntegerData(argv[i+1], 1, " ,");
                        i++;
                        info->flagHeightRange++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("RMaxX") {
                    if(i+1<argc) {
                        info->RMaxX = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagRMaxX++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("mag") {
                    if(i+1<argc) {
                        info->mag = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagmag++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("truePitch") {
                    if(i+1<argc) {
                        info->truePitch = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagtruePitch++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("PixelSize") {
                    if(i+1<argc) {
                        info->PixelSize = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagPixelSize++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("finaly") {
                    if(i+1<argc) {
                        info->finaly = stringGetNthIntegerData(argv[i+1], 1, " ,");
                        i++;
                        info->flagfinaly++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("Ignore") {
                    if(i+1<argc) {
                        info->Ignore = stringGetNthIntegerData(argv[i+1], 1, " ,");
                        i++;
                        info->flagIgnore++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("c") {
                    if(i+1<argc) {
                        info->configFile = stringGetNthWord(argv[i+1], 1, " ,");
                        i++;
                        info->flagconfigFile++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("m") {
                    if(i+1<argc) {
                        info->mode = stringGetNthIntegerData(argv[i+1], 1, " ,");
                        i++;
                        info->flagmode++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("h") {
                    usage(argv[0]);
                    exit(EXIT_SUCCESS);
                    break;
                }
                SCASE("html") {
                    htmlBeforeUsage(argv[0]);
                    usage(argv[0]);
                    htmlAfterUsage(argv[0]);
                    exit(EXIT_SUCCESS);
                    break;
                }
                SDEFAULT {
                    fprintf(stderr, "Not Supported Options: :%s\n", argv[i]);
                    usage(argv[0]);
                    exit(EXIT_FAILURE);
                    break;
                }
            SSWITCHEND;
        } 
    } 
} 
