#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :Input: mrcImage\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Essential :Output: mrcImage\n");
    fprintf(stderr, "    [-center             cx                  (0         )cy                  (0         )cz                  (0         )] :Optional  :Center:\n");
    fprintf(stderr, "    [-w[idth]            wx                  (0         )wy                  (0         )wz                  (0         )] :Optional  :Width\n");
    fprintf(stderr, "    [-r[dius]            r                   (0         )] :Optional  :Radius\n");
    fprintf(stderr, "    [-w[idth]r[dius]     w                   (0         )] :Optional  :Width for R\n");
    fprintf(stderr, "    [-w[idth]z           widthz              (0         )] :Optional  :Width for z\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
