/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% mrc2gif ver %I%
#%Z% Created by 
#%Z%
#%Z% Usage : mrc2gif
#%Z% Attention
#%Z%
*/
static char __sccs_id[] = "%Z%mrc2gif ver%I%; Date:%D% %Z%";

#undef DEBUG
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>                  
#define GLOBAL_DECLARATION
#include "../inc/config.h"
#include "mrcImage.h"
//#include "gif_lib.h"
#include "gifFile.h"

void
main(int argc, char* argv[]) 
{
	long status, i;
	mrc2gifInfo info;
	float ftmp;
	ColorMapObject* ColorMap;
	mrcImage in;
	int maxColorIndex=256;
	
	init0(&info);
    argCheck(&info, argc, argv);
    init1(&info);

	mrcFileRead(&in, info.inFile,  "in main", 0);
	if(info.flagLow) {
		in.HeaderAMin = info.Low;
	}
	if(info.flagHigh) {
		in.HeaderAMax = info.High;
	}
	if(info.Inverse) {
		ftmp = in.HeaderAMin;
		in.HeaderAMin = in.HeaderAMax;
		in.HeaderAMax = ftmp;
	}

	ColorMap = gifColorMapInit(maxColorIndex, NULL);
	gifColorMapGrey(ColorMap, maxColorIndex);

	lmrc2gif(info.outFile, &in, ColorMap, 0);	
	exit(EXIT_SUCCESS);
}

void
additionalUsage()
{
}
