/*
# hostCondition : $Revision$  
# $Date$ 
# Created by $Author$
# Usage : hostCondition
# Attention
#   $Loccker$
#  	$State$ 
#
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>                  
#define GLOBAL_DECLARATION
#include "../inc/config.h"

#define DEBUG
#include "genUtil.h"

/*
Example:
typedef struct lhostConditionInfo {
	float a;
	int   b;
} lhostConditionInfo;

typedef enum lhostConditionMode {
	a=0,
	b=1
} lhostConditionMode;
*/

union endianTest {
	int   i;
	short s[2];
	char  c[4];
};

void
byteSizeCheck(FILE* fpt)
{
	fprintf(fpt, "---- Byte Size ----\n");
	fprintf(fpt, "Byte: char   %d \n", sizeof(char));
	fprintf(fpt, "Byte: short  %d \n", sizeof(short));
	fprintf(fpt, "Byte: int    %d \n", sizeof(int));
	fprintf(fpt, "Byte: long   %d \n", sizeof(long));
	fprintf(fpt, "Byte: float  %d \n", sizeof(float));
	fprintf(fpt, "Byte: double %d \n", sizeof(double));
}

void
endianCheck(FILE* fpt)
{
	union endianTest t;
	fprintf(fpt, "---- Endianness/ByteOrder ----\n");

	t.i = 10;
	if(t.c[0]==t.i) {
		fprintf(fpt, "Little Endian / X86\n");
	} else {
		fprintf(fpt, "Big Endian / nonX86  \n");
	}
}

int
main(int argc, char* argv[]) 
{
	hostConditionInfo info;

	init0(&info);
    argCheck(&info, argc, argv);
    init1(&info);

	DEBUGPRINT("Program Start\n");
	byteSizeCheck(info.fptOut);
	endianCheck(info.fptOut);
	exit(EXIT_SUCCESS);
}

void
additionalUsage()
{
	fprintf(stderr, "----- Additional Usage -----\n");
}
