/*
# eosPointRead : $Revision$  
# $Date$ 
# Created by $Author$
# Usage : eosPointRead 
# Attention
#   $Loccker$
#  	$State$ 
#
*/
/* $Log$ */

#undef DEBUG
#include "genUtil.h"
#include "String.h"
#include "../inc/eosPoint.h"

void
eosPointRead(FILE* fpt, eosPoint* p, int mode)
{
	char s[STRING_MAX_LENGTH];
	eosPointCoord pc;
	eosPointParaTypeReal x, y, z, sig, sigx, sigy, sigz;

	eosPointInit(p, NULL);
	eosPointCoordInit(&pc, 0); 
	while(NULL!=stringGetFromFileWithSkippingComment(s, "in eosPointRead", fpt, stderr, 3)) {
		x = stringGetNthRealData(s, 1, " ,\t");
		y = stringGetNthRealData(s, 2, " ,\t");
		z = stringGetNthRealData(s, 3, " ,\t");
		eosPointCoordSet(&pc, x, y, z);
		if(mode&0x01) {
			sig = stringGetNthRealData(s, 4, " ,\t");
			pc.sigma = sig;
		}
		if(mode&0x02) {
			sigx = stringGetNthRealData(s, 5, " ,\t");
			sigy = stringGetNthRealData(s, 6, " ,\t");
			sigz = stringGetNthRealData(s, 7, " ,\t");
			eosPointCoordSigSet(&pc, sigx, sigy, sigz);
		}
		eosPointAppend(p, &pc, 0);
		DEBUGPRINT7("%f %f %f %f %f %f %f\n", x, y, z, sig, sigx, sigy, sigz);
		DEBUGPRINT7("%f %f %f %f %f %f %f\n", p->current->p.coord.data[0], 
												p->current->p.coord.data[1],	
												p->current->p.coord.data[2],	
												p->current->p.sigma,	
												p->current->p.sig.data[0],	
												p->current->p.sig.data[1],	
												p->current->p.sig.data[2]);
	}
}
