/*
# mrc2DFTto3DFT : $Revision$  
# $Date$ 
# Created by $Author$
# Usage : mrc2DFTto3DFT
# Attention
#   $Loccker$
#  	$State$ 
#
*/
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <math.h>                  
#define GLOBAL_DECLARATION
#include "../inc/config.h"

#define DEBUG
#include "genUtil.h"
#include "lmrcFFTCentralSection.h"
//#include "Class.h"

/*
Example:
typedef struct lmrc2DFTto3DFTInfo {
	float a;
	int   b;
} lmrc2DFTto3DFTInfo;

typedef enum lmrc2DFTto3DFTMode {
	a=0,
	b=1
} lmrc2DFTto3DFTMode;
*/

int
main(int argc, char* argv[]) 
{
	mrc2DFTto3DFTInfo info;
    lmrcFFTCentralSectionInfo linfo;
    char file2d[256], file3d[256], buf[256];
    char filename[]="hogehoge";
    double probability;
    mrcImage temp3d, in ,count;
    mrcImage* Inlist;
    mrcImage Out;
    int num,ref,i=0;
    int size;
    clock_t start,end;
    FILE* fp;


    start = clock();

	init0(&info);
    argCheck(&info, argc, argv);
    init1(&info);
	DEBUGPRINT("Program Start\n");

    mrcFileRead(&temp3d, info.temp3d, "in main", 0);
   // mrcFileRead(&Out, info.In3D, "in main", 0);

    int c=0;
    linfo.TransX = 0.0;
    linfo.TransY = 0.0;
    linfo.InterpMode = 1.0;
    
    Out.Header = temp3d.Header;
    count.Header = temp3d.Header;
    mrcInit(&Out, NULL);
    mrcInit(&count, NULL);

    while(fgets(buf, 256, info.fptIn) != NULL){
        size ++;
    }
    rewind(info.fptIn);

    Inlist = malloc(sizeof(mrcImage)*size);
    if(Inlist ==NULL){
        printf("malloc error\n");
    }
    num =0;
    while(fscanf(info.fptIn,"%s %s %lf %lf %lf %s %d %lf",file2d, linfo.EulerMode, &linfo.Rot1, &linfo.Rot2, &linfo.Rot3, file3d, &num, &probability) != EOF){
        if((ref=strcmp(filename,file2d))!= 0){
   //     DEBUGPRINT1("Num %d\n", i);
        mrcFileRead(&Inlist[i], file2d, "in main", 0);
        strcpy(filename,file2d);
//        DEBUGPRINT2("filename %s %s\n",filename, file2d);
        i++;
        }
        num =i-1;
 //       DEBUGPRINT1("Num %d\n", i);
 //       DEBUGPRINT2("in Header:  %d %d \n", Inlist[num].HeaderN.x, Inlist[num].HeaderN.y)
        lmrcImageFFTCentralSectionPut(&Out, &count, &temp3d, &Inlist[i-1], probability, &linfo, &c, info.mode);
    }
    lmrcImageFFTRhoFilter(&Out, &count, &linfo, info.mode);
    mrcFileWrite(&Out, info.Out, "in main", 0);
    free(Inlist);
    end = clock();
    DEBUGPRINT1("time %f\n",(double)(end-start)/CLOCKS_PER_SEC);
	exit(EXIT_SUCCESS);
}

void
additionalUsage()
{
	fprintf(stderr, "----- Additional Usage -----\n");
}
