#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-t[itle]            Title               (NULL      )] :Optional  :Title[80]\n");
    fprintf(stderr, "    [-s[tep]             xStep               (1.0       )yStep               (1.0       )] :Optional  :Step[A]\n");
    fprintf(stderr, "    [-M[ax]              MaxX                (1.0       )MaxY                (1.0       )] :Optional  :Max[GridUnit]\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Optional  :InputDataFile[mrcImage]\n");
    fprintf(stderr, "    [-1[output]          Nea                 (NULL      )] :Optional  :NearSide[llData]\n");
    fprintf(stderr, "    [-2[output]          Far                 (NULL      )] :Optional  :FarSide [llData]\n");
    fprintf(stderr, "    [-R[otationAngle]    RotationAngle       (0.0       )] :Optional  :Ratation Angle [Degree]\n");
    fprintf(stderr, "    [-O[mega]            Omega               (0.0       )] :Optional  :Omega[Degree]\n");
    fprintf(stderr, "    [-S[hear]            Shear               (0.0       )] :Optional  :Shear[Degree]\n");
    fprintf(stderr, "    [-I[every]           ievery              (0         )] :Optional  :ievery\n");
    fprintf(stderr, "    [-axl                axl                 (0.0       )] :Optional  :axl\n");
    fprintf(stderr, "    [-ayl                ayl                 (0.0       )] :Optional  :ayl\n");
    fprintf(stderr, "    [-x[Shift]           xShift              (0.0       )] :Optional  :[GridUnit]\n");
    fprintf(stderr, "    [-l[lMax]            llMax               (0         )] :Optional  :\n");
    fprintf(stderr, "    [-d[elRInv]          delRInv             (0.0       )] :Optional  :[A]\n");
    fprintf(stderr, "    [-f[lagOutputInfo]   ] :Optional  :\n");
    fprintf(stderr, "    [-L[ayerLineInfo]    n                   (0         )l                   (0         )Y                   (0.0       )leftMin             (0.0       )leftMax             (0.0       )rightMin            (0.0       )rightMax            (0.0       )weight              (1.0       )... ] :Variable  :\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
