#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nputMS]          InMS                (NULL      )] :Essential :InputMapSet\n");
    fprintf(stderr, "    [-i[nput]F[ile]      InFL                (NULL      )] :Optional  :InputFETDataFileList\n");
    fprintf(stderr, "    [-i[nput]M[aps]      InML                (NULL      )] :Optional  :InputMapDataFileList\n");
    fprintf(stderr, "    [-T[emprature]       ITemp               (300.0     )] :Optional  :InitialTemprature\n");
    fprintf(stderr, "    [-a[nnealing]s[chedule]1AS1                 (10        )] :Optional  :Repeatas1TimesInSameTemp\n");
    fprintf(stderr, "    [-a[nnealing]s[chedule]2AS2                 (0.9       )] :Optional  :TempratureDecreaseConstant\n");
    fprintf(stderr, "    [-a[nnealing]s[chedule]3AS3                 (10        )] :Optional  :Repeatas3Times\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
