#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]pdb[File]   InPdb               (NULL      )] :Essential :InputDataFile\n");
    fprintf(stderr, "    [-i[nput]mrc[File]   InMrc               (NULL      )] :Essential :InputDataFile\n");
    fprintf(stderr, "    [-o[utput of ]mrc    OutMrc              (NULL      )] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-o[utput of ]txt    OutTxt              (NULL      )] :Optional  :OutputDataFile\n");
    fprintf(stderr, "    [-o[utput of ]par    OutPar              (stdout    )] :Optional  :OutputDataFile\n");
    fprintf(stderr, "    [-o[utput of ]pdb    OutPDB              (NULL      )] :Optional  :OutputDataFile\n");
    fprintf(stderr, "    [-xmin               xmin                (0         )] :Optional  :xmin for fitting\n");
    fprintf(stderr, "    [-xmax               xmax                (0         )] :Optional  :xmax for fitting\n");
    fprintf(stderr, "    [-xd[elta]           xDelta              (1         )] :Optional  :delta x for fitting\n");
    fprintf(stderr, "    [-ymin               ymin                (0         )] :Optional  :ymin for fitting\n");
    fprintf(stderr, "    [-ymax               ymax                (0         )] :Optional  :ymax for fitting\n");
    fprintf(stderr, "    [-yd[elta]           yDelta              (1         )] :Optional  :delta y for fitting\n");
    fprintf(stderr, "    [-zmin               zmin                (0         )] :Optional  :zmin for fitting\n");
    fprintf(stderr, "    [-zmax               zmax                (82        )] :Optional  :zmax for fitting\n");
    fprintf(stderr, "    [-zd[elta]           zDelta              (1         )] :Optional  :delta z for fitting\n");
    fprintf(stderr, "    [-E[uler]A[ngle]     EulerAngle          (ZOYS      )] :Optional  :Euler Angle for three-angle\n");
    fprintf(stderr, "    [-phimin             phimin              (0         )] :Optional  :phimin for fitting(degree)\n");
    fprintf(stderr, "    [-phimax             phimax              (194       )] :Optional  :phimax for fitting(degree)\n");
    fprintf(stderr, "    [-phid[elta]         phiDelta            (2         )] :Optional  :delta phi for fitting(degree)\n");
    fprintf(stderr, "    [-psimin             psimin              (0         )] :Optional  :psimin for fitting(degree)\n");
    fprintf(stderr, "    [-psimax             psimax              (0         )] :Optional  :psimax for fitting(degree)\n");
    fprintf(stderr, "    [-psid[elta]         psiDelta            (2         )] :Optional  :delta psi for fitting(degree)\n");
    fprintf(stderr, "    [-thetamin           thetamin            (0         )] :Optional  :thetamin for fitting(degree)\n");
    fprintf(stderr, "    [-thetamax           thetamax            (0         )] :Optional  :thetamax for fitting(degree)\n");
    fprintf(stderr, "    [-thetad[elta]       thetaDelta          (2         )] :Optional  :delta theta for fitting(degree)\n");
    fprintf(stderr, "    [-n[ormalize]w[eight]normalizeWeight     (100000000.0)] :Optional  :weight for normalize\n");
    fprintf(stderr, "    [-n[ormalize]C[ontour]normalizeContour    (0.0       )] :Optional  :Contour Level for Normalize\n");
    fprintf(stderr, "    [-I[nverse]          ] :Optional  :Black is High Density.\n");
    fprintf(stderr, "    [-Zminus             ] :Optional  :Shift to -z\n");
    fprintf(stderr, "    [-Tfactor            ] :Optional  :Consider T factor\n");
    fprintf(stderr, "    [-T[ factor ]lim[it] Tlim                (60        )] :Optional  :The atom will be neglected\n");
    fprintf(stderr, "    [-Centre             ] :Optional  :Filament-axis is x=0, y=0\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    fprintf(stderr, "    [-C[ontour]          contourLevel        (0.0       )... ] :Variable  :ContourLevel\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
