#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]1           In1                 (NULL      )] :Essential :InputSinogramFETFile1\n");
    fprintf(stderr, "    [-i[nput]2           In2                 (NULL      )] :Essential :InputSinogramFETFile2\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-w[eight]           Weight              (NULL      )] :Optional  :WeightDataFile mrcFormat\n");
    fprintf(stderr, "    [-s[tandard]d[eviation]SD                  (NULL      )] :Optional  :readSDfileForNormalize\n");
    fprintf(stderr, "    [-n[orm]m[ode]       NM                  (0         )] :Optional  :normalizemode\n");
    fprintf(stderr, "    [-c[alc]mode         CMode               (0         )] :Optional  :calculateMode\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
