#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputDataFile\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Optional  :Output: correlation\n");
    fprintf(stderr, "    [-O[utput]           Out2                (stdout    )] :Optional  :Output: SymmetryInformation \n");
    fprintf(stderr, "    [-A[verage]          Avg                 (NULL      )] :Optional  :Output: Average\n");
    fprintf(stderr, "    [-centreMode         centreMode          (1         )] :Optional  :Input: 0 : Gravity of Centre; 1 : Search n-fold\n");
    fprintf(stderr, "    [-t1[threshold1]     threshold1          (1.8       )] :Optional  :Threshold of CheckByAdd\n");
    fprintf(stderr, "    [-t2[threshold2]     threshold2          (0.9       )] :Optional  :Threshold in deciding the symmetry number\n");
    fprintf(stderr, "    [-m1[mode1]          mode1               (3         )] :Optional  :Mode of Check\n");
    fprintf(stderr, "    [-m2[mode2]          mode2               (2         )] :Optional  :Mode of Substruction\n");
    fprintf(stderr, "    [-dr[delta r]        dr                  (1         )] :Optional  :Delta r of outputfile.\n");
    fprintf(stderr, "    [-dtheta[delta theta]dtheta              (1         )] :Optional  :Delta theta of outputfile.[DEGREE]\n");
    fprintf(stderr, "    [-n[umber]           n                   (10        )] :Optional  :Check to the number.\n");
    fprintf(stderr, "    [-n[umber]Range      nmin                (2         )nmax                (10        )] :Optional  :Check to the number.\n");
    fprintf(stderr, "    [-In                 Image               (NULL      )Back                (NULL      )] :Optional  :InputDataFile: Image and Back\n");
    fprintf(stderr, "    [-rangex             minx                (-3        )maxx                (3         )delx                (1         )] :Optional  :Input: \n");
    fprintf(stderr, "    [-rangey             miny                (-3        )maxy                (3         )dely                (1         )] :Optional  :Input: \n");
    fprintf(stderr, "    [-rangez             minz                (0         )maxz                (0         )delz                (1         )] :Optional  :Input: \n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
