#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :Input: mrcImage\n");
    fprintf(stderr, "    [-o[utput]           Out                 (          )] :Optional  :Output: Basename\n");
    fprintf(stderr, "    [-s[uffix]           Suffix              (%04d%04d%04d.splt)] :Optional  :Output: Suffix\n");
    fprintf(stderr, "    [-H[eight]           Height              (0         )] :Optional  :Input: Height[y]: SplitSize [pixel]\n");
    fprintf(stderr, "    [-W[idth]            Width               (0         )] :Optional  :Input: Width[x]: SplitSize [pixel]\n");
    fprintf(stderr, "    [-S[ection]          Section             (0         )] :Optional  :Input: Section[z]: SplitSize [pixel]\n");
    fprintf(stderr, "    [-H[eight]A[ngstrom] HeightA             (0         )] :Optional  :Input: Height: SplitSize [A]\n");
    fprintf(stderr, "    [-W[idth]A[ngstrom]  WidthA              (0         )] :Optional  :Input: Width: SplitSize [A]\n");
    fprintf(stderr, "    [-S[ection]A[ngstrom]SectionA            (0         )] :Optional  :Input: Section: SplitSize [A]\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
