#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :Input: test(mrcImage)\n");
    fprintf(stderr, "    [-r[eference]        Ref                 (NULL      )] :Essential :Input: ref(mrcImage)\n");
    fprintf(stderr, "    [-o[utput]           Out                 (stdout    )] :Optional  :Output: Parameters\n");
    fprintf(stderr, "    [-fit                Fit                 (NULL      )] :Optional  :Output: fit(mrcImage) <- test \n");
    fprintf(stderr, "    [-fitMat             FitMat              (NULL      )] :Optional  :Output: Matrix3D for fit(mrcImage) <- test \n");
    fprintf(stderr, "    [-iMode              IMode               (2         )] :Optional  :InterpolationMode\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    fprintf(stderr, "    [-C[ontour]          Contour             (1.0       )... ] :Variable  :Contour(test/ref)\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
