#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputDataFile\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-nx                 nx                  (0         )] :Optional  :Default:in.HeaderN.x\n");
    fprintf(stderr, "    [-ny                 ny                  (0         )] :Optional  :Default:in.HeaderN.y\n");
    fprintf(stderr, "    [-nz                 nz                  (0         )] :Optional  :Default:in.HeaderN.z\n");
    fprintf(stderr, "    [-cx                 cx                  (0         )] :Optional  :Default:Center of image\n");
    fprintf(stderr, "    [-cy                 cy                  (0         )] :Optional  :Default:Center of image\n");
    fprintf(stderr, "    [-cz                 cz                  (0         )] :Optional  :Default:Center of image\n");
    fprintf(stderr, "    [-Rot[ation]         Euler               (0         )Rot1                (0         )Rot2                (0         )Rot3                (0         )] :Optional  :Masking Area Rotation Default: ZONS 0 0 0\n");
    fprintf(stderr, "    [-Shape              Shape               (0         )] :Optional  :Default:Circle\n");
    fprintf(stderr, "    [-Normalize          Normalize           (0         )] :Optional  :Default:No Op\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
