#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputDataFile\n");
    fprintf(stderr, "    [-r[eference]        Ref                 (NULL      )] :Essential :ReferenceDataFile\n");
    fprintf(stderr, "    [-o[utput]           Out                 (stdout    )] :Optional  :Output Optimum [text]\n");
    fprintf(stderr, "    [-oP[utput]          Out2                (NULL      )] :Optional  :Output Distribution [mrc image]\n");
    fprintf(stderr, "    [-oC[utput]          OutC                (NULL      )] :Optional  :Output CTF Information file\n");
    fprintf(stderr, "    [-oF[utput]          OutF                (NULL      )] :Optional  :Output Result FFT[mrc image]\n");
    fprintf(stderr, "    [-kV                 kV                  (200       )] :Optional  :AccVol[kV]\n");
    fprintf(stderr, "    [-Cs                 Cs                  (2.1       )] :Optional  :Cs[mm]\n");
    fprintf(stderr, "    [-Ain                Ain                 (0.02      )] :Optional  :IlluminationAperture[mrad]\n");
    fprintf(stderr, "    [-W[hiteNoise]       WhiteNoise          (1.0       )] :Optional  :\n");
    fprintf(stderr, "    [-df                 mindf               (0.0       )maxdf               (200000    )deldf               (1000      )] :Optional  :df[A] for in\n");
    fprintf(stderr, "    [-AoverP             minAoverP           (0.0       )maxAoverP           (1.0       )delAoverP           (0.01      )] :Optional  :AoverP[A] for in\n");
    fprintf(stderr, "    [-Rmin               Rmin                (0.0       )] :Optional  :Rmin[/A]\n");
    fprintf(stderr, "    [-Rmax               Rmax                (0.1       )] :Optional  :Rmax[/A]\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]F[ilter type]mF                  (1         )] :Optional  :Filter Type\n");
    fprintf(stderr, "    [-m[ode]W[ight type] mW                  (0         )] :Optional  :Wight Type\n");
    fprintf(stderr, "    [-m[ode]S[um type]   mS                  (0         )] :Optional  :Sum Type\n");
    fprintf(stderr, "    [-m[ode]C[TF Info type]mC                  (0         )] :Optional  :CTF Information Type\n");
    fprintf(stderr, "    [-M[ode]             M                   (0         )] :Optional  :ref Type\n");
    fprintf(stderr, "    [-PixelSize          PixelSize           (5         )] :Optional  :Pixel Size [A]\n");
    fprintf(stderr, "    [-Width              Width               (120       )] :Optional  :Pad Width [pixel]\n");
    fprintf(stderr, "    [-truePitch          truePitch           (430       )] :Optional  :True Pitch [A]\n");
    fprintf(stderr, "    [-dfRef              firstDf             (70000     )withinDf            (1000      )] :Optional  :dfRef for ref\n");
    fprintf(stderr, "    [-AoverPRef          firstAoverP         (0.05      )withinAoverP        (0.01      )] :Optional  :A over P Ref for ref\n");
    fprintf(stderr, "    [-MaxIter            maxiter             (10        )] :Optional  :MaxIteration for ref\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
