#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputDataFile(AutoRotationCorrelationResult)\n");
    fprintf(stderr, "    [-I[nput]            InData              (NULL      )] :Optional  :InputDataFile(test Data)\n");
    fprintf(stderr, "    [-r[ef]              Ref                 (NULL      )] :Essential :ReferenceFile\n");
    fprintf(stderr, "    [-pdb                PDB                 (NULL      )] :Optional  :ReferenceFile\n");
    fprintf(stderr, "    [-o[utput]           Out                 (stdout    )] :Optional  :OutputDataFile\n");
    fprintf(stderr, "    [-max                Max                 (NULL      )] :Optional  :OutputDataFile[MaxImage]\n");
    fprintf(stderr, "    [-maxRot             MaxRot              (NULL      )] :Optional  :OutputDataFile[MaxImageWithRotationAnShift]\n");
    fprintf(stderr, "    [-maxpdb             MaxPDB              (NULL      )] :Optional  :OutputDataFile[MaxImage]\n");
    fprintf(stderr, "    [-maxpdbForRasmol    MaxPDBForRasmol     (NULL      )] :Optional  :OutputDataFile[MaxImage]\n");
    fprintf(stderr, "    [-S[tartRot]         Sx                  (0.0       )Sy                  (0.0       )Sz                  (0.0       )] :Optional  :StartRot[DEGREE]\n");
    fprintf(stderr, "    [-top                Top                 (1         )] :Optional  :TopEntry\n");
    fprintf(stderr, "    [-wish               ] :Optional  :Display3D\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
