#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :Input: mrc[test]\n");
    fprintf(stderr, "    [-r[ef]              Ref                 (NULL      )] :Essential :Input: mrc[ref]\n");
    fprintf(stderr, "    [-o[utput]           Out                 (stdout    )] :Optional  :Output: Parameter\n");
    fprintf(stderr, "    [-cor                Cor                 (NULL      )] :Optional  :Output: CorMap\n");
    fprintf(stderr, "    [-fit                Fit                 (stdout    )] :Optional  :Output: Best Fit\n");
    fprintf(stderr, "    [-E[uler]A[ngle]     EulerAngle          (YOYS      )] :Optional  :Input: EulerAngle\n");
    fprintf(stderr, "    [-Rot1               Rot1Min             (0.0       )Rot1Max             (360.0     )Rot1Delta           (5.0       )] :Optional  :Rot1\n");
    fprintf(stderr, "    [-Rot2               Rot2Min             (0.0       )Rot2Max             (180.0     )Rot2Delta           (5.0       )] :Optional  :Rot2\n");
    fprintf(stderr, "    [-Rot3               Rot3Min             (0.0       )Rot3Max             (360.0     )Rot3Delta           (5.0       )] :Optional  :Rot3\n");
    fprintf(stderr, "    [-M[ode]             Mode                (0         )] :Optional  :Mode: Correlation Mode\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode: \n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
