#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-M[odel]            Model               (NULL      )] :Essential :Input: ModelFileName(llData)\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :Input: InputDataFile\n");
    fprintf(stderr, "    [-l[ayer]            llInfo              (NULL      )] :Essential :Input: Layer Line Information\n");
    fprintf(stderr, "    [-A[verage]          Ave                 (NULL      )] :Essential :Output: Averaged File Name\n");
    fprintf(stderr, "    [-o[utput]           OutParam            (stdout    )] :Optional  :Output: FittedParameter\n");
    fprintf(stderr, "    [-o2[utput]          OutParam2           (NULL      )] :Optional  :Output: FittedParameter(phi, z)\n");
    fprintf(stderr, "    [-O[utput]           Out                 (NULL      )] :Optional  :Output: FittedData\n");
    fprintf(stderr, "    [-P2[plot]           P2                  (NULL      )] :Optional  :Output: P2PlotData\n");
    fprintf(stderr, "    [-t[ruePitch]        truePitch           (1.0       )] :Optional  :True Pitch\n");
    fprintf(stderr, "    [-d[eltaR]           dR                  (1.0       )] :Optional  :deltaR\n");
    fprintf(stderr, "    [-r[adial]           rmin                (1.0       )rmax                (1.0       )dr                  (1.0       )] :Optional  :Radial[Ratio]\n");
    fprintf(stderr, "    [-p[hi]              phimin              (0.0       )phimax              (180.0     )dphi                (5.0       )] :Optional  :Phi [degree]\n");
    fprintf(stderr, "    [-z[shift]           zmin                (0.0       )zmax                (60.0      )dz                  (5.0       )] :Optional  :z [A]\n");
    fprintf(stderr, "    [-withoutAntiPole    ] :Optional  :Not Allow Antipole\n");
    fprintf(stderr, "    [-C[utValue]         CutValue            (1.0       )] :Optional  :CutValue\n");
    fprintf(stderr, "    [-pvm                pvm                 (0         )] :Optional  :PVM: \n");
    fprintf(stderr, "    [-pvmList            pvmList             (stdin     )] :Optional  :PVM: HostList\n");
    fprintf(stderr, "    [-pvmList            Log                 (stdout    )] :Optional  :PVM: HostList\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
