/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% lmrc2Dto3D.c ver %I%
#%Z% Created by tacyas 
#%Z%
#%Z% Usage : mrc2Dto3D.c
#%Z% Attention
#%Z%
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>                  
#undef DEBUG
#include "genUtil.h"
#include "Memory.h"
#include "String.h"
#include "mrcImage.h"
#include "Matrix3D.h"
#include "lmrc2Dto3D.h"
#include "lmrcImageRhoFiltering.h"


void 
lmrc2Dto3D(mrcImage* out, mrcImage* in, lmrc2Dto3DInfo* linfo, long mode)
{
	mrcImageParaTypeInteger i;
	mrcImageParaTypeInteger num;
	mrcImageParaTypeReal    x, y, z;
	mrcImageParaTypeReal    gx, gy, gz;
	mrcImageParaTypeReal    g3x, g3y, g3z;
	mrcImageParaTypeReal    prjx, prjy, prjz;
	mrcImage                tmp;
	mrcImage                prj;
	double                  data, projdata;
	Matrix3D                Matrix;
	Matrix3D                MatrixAnti;
	floatVector             v;
	double lenx, leny, lenz;
	double weight, normz;
	tmp.Header    = prj.Header    = in->Header;
	tmp.HeaderN.z = prj.HeaderN.z = 1;
	mrcInit(&tmp, NULL); mrcInit(&prj, NULL); 

	out->Header = in->Header;
	if(linfo->flagOutputSize) {
		out->HeaderN.x = linfo->Nx;
		out->HeaderN.y = linfo->Ny;
		out->HeaderN.z = linfo->Nz;
	} else { 
		out->HeaderN.x = MAX(in->HeaderN.x, in->HeaderN.y);
		out->HeaderN.y = MAX(in->HeaderN.x, in->HeaderN.y);
		out->HeaderN.z = MAX(in->HeaderN.x, in->HeaderN.y);
	}
	out->HeaderLength.z = out->HeaderLength.x;
	mrcInit(out, NULL);
	lenx =  (out->HeaderN.x-1)/2.0;
	leny =  (out->HeaderN.y-1)/2.0;
	lenz =  (out->HeaderN.z-1)/2.0;

	floatVectorInit(&v, 4);
	v.data[3] = 1.0;
	num = in->numTailer;

	for(i=0; i<num; i++) {
		fprintf(stderr, "%d / %d", i, num);
		DEBUGPRINT4("%ld: %g %g %g\n", i, in->Tailer[i].Cont.Rot1*DEGREE, in->Tailer[i].Cont.Rot2*DEGREE, in->Tailer[i].Cont.Rot3*DEGREE);
		/* Projection Data Set */
		mrcImageSectionGet(&tmp, in, i, 1); 	

		/* Set Matrix */
		matrix3DRotationSetFollowingEulerAngle(Matrix,
										in->Tailer[i].Cont.EulerAngleMode,
										in->Tailer[i].Cont.Rot1, 
										in->Tailer[i].Cont.Rot2, 
										in->Tailer[i].Cont.Rot3, 
										MATRIX_3D_MODE_INITIALIZE);

		if(linfo->flagDouble && linfo->flagPlusXrot) {
			matrix3DRotationSetFollowingEulerAngle(Matrix,
										"XEYS",
										180*RADIAN, 
										0, 
										0, 
										MATRIX_3D_MODE_NOT_INITIALIZE);
		}
		matrix3DRotationAntiSetFollowingEulerAngle(MatrixAnti,
										in->Tailer[i].Cont.EulerAngleMode,
										in->Tailer[i].Cont.Rot1, 
										in->Tailer[i].Cont.Rot2, 
										in->Tailer[i].Cont.Rot3, 
										MATRIX_3D_MODE_INITIALIZE);

		/* Filtering */
		switch(linfo->mode) {
			case mrc2Dto3DModeSimpleBackProjection: {
				prj = tmp;
				break;
			}
			case mrc2Dto3DModeFilteredBackProjection: {
				if(linfo->flagDouble) {
					/* Preparing Rho Filtering */
					linfo->CounterForWeight = lmrcImageRhoFiltering2(out, Matrix, i, &linfo->rhoInfo, 0);
					prj = tmp;
				} else {
					lmrcImageRhoFiltering(&prj, &tmp, MatrixAnti, linfo->singleTiltMode);
				}
				break;
			}
			default: {
				break;
			}
		}

		/* Determination of Image Centre */	
		switch(linfo->mode) {
			case mrc2Dto3DModeSimpleBackProjection: 
			case mrc2Dto3DModeFilteredBackProjection: {
				g3x = (out->HeaderN.x - 1)/2.0;
				g3y = (out->HeaderN.y - 1)/2.0;
				g3z = (out->HeaderN.z - 1)/2.0;
				gx  = (in->HeaderN.x  - 1)/2.0;
				gy  = (in->HeaderN.y  - 1)/2.0;
				gz  = 0.0;
				break;
			}
			default: {
				fprintf(stderr, "Not supported mode: %ld : lmrc2D3D\n", linfo->mode);
				return;
			}
		}
		
		/* */
		switch(linfo->mode) {
			case mrc2Dto3DModeSimpleBackProjection: { /* Backprojection */
				for(z=0; z<out->HeaderN.z; z++) {
				for(y=0; y<out->HeaderN.y; y++) {
				for(x=0; x<out->HeaderN.x; x++) {
					v.data[0] = x-g3x; 
					v.data[1] = y-g3y; 
					v.data[2] = z-g3z;
					//v.data[3] = 1;
					matrix3DMultiplyVector(&v, Matrix);
					//DEBUGPRINT2("x %f -> %f\n", x - g3x, v.data[0]);
					//DEBUGPRINT2("y %f -> %f\n", y - g3y, v.data[1]);
					//DEBUGPRINT2("z %f -> %f\n", z - g3z, v.data[2]);
					prjx = v.data[0] + gx; 
					prjy = v.data[1] + gy;
					prjz = v.data[2] + g3z;
					//DEBUGPRINT2("x %f -> %f\n", x, prjx);
					//DEBUGPRINT2("y %f -> %f\n", y, prjy);
					//DEBUGPRINT1("z %f      \n", z);
					mrcPixelDataGet(out, x, y, z, &data, mrcPixelRePart, mrcPixelHowNearest);
					if( -0.5<=prjx && prjx<prj.HeaderN.x-0.5
					  &&-0.5<=prjy && prjy<prj.HeaderN.y-0.5) {
						mrcPixelDataGet(&prj, prjx, prjy, 0.0, &projdata, mrcPixelRePart, linfo->InterpolationMode);
						mrcPixelDataSet(out, x, y, z, data + projdata, mrcPixelRePart);
					}
				}
				}
				}
				break;
			}
			case mrc2Dto3DModeFilteredBackProjection: {
				for(z=0; z<out->HeaderN.z; z++) {
				for(y=0; y<out->HeaderN.y; y++) {
				for(x=0; x<out->HeaderN.x; x++) {
					v.data[0] = x-g3x; 
					v.data[1] = y-g3y; 
					v.data[2] = z-g3z;
					v.data[3] = 1;
					matrix3DMultiplyVector(&v, Matrix);
					//DEBUGPRINT2("x %f -> %f\n", x - g3x, v.data[0]);
					//DEBUGPRINT2("y %f -> %f\n", y - g3y, v.data[1]);
					//DEBUGPRINT2("z %f -> %f\n", z - g3z, v.data[2]);
					prjx = v.data[0] + gx; 
					prjy = v.data[1] + gy;
					prjz = v.data[2] + g3z;
					//DEBUGPRINT2("x %f -> %f\n", x, prjx);
					//DEBUGPRINT2("y %f -> %f\n", y, prjy);
					//DEBUGPRINT1("z %f      \n", z);
					//
					if(-0.5<=prjz && prjz < out->HeaderN.z - 0.5) {	
						mrcPixelDataGet(out, x, y, z, &data, mrcPixelRePart, mrcPixelHowNearest);
						if( -0.5<=prjx && prjx<prj.HeaderN.x-0.5
					  	  &&-0.5<=prjy && prjy<prj.HeaderN.y-0.5) {
							mrcPixelDataGet(&prj, prjx, prjy, 0.0, &projdata, mrcPixelRePart, linfo->InterpolationMode);
							if(linfo->flagDouble && linfo->rhoInfo.flagThicknessWeight) {
								normz = fabs(v.data[2]/g3z); 
								if(normz < 0.9) {
								} else if(normz < 1) { 
									projdata *=  (cos(M_PI*(normz-0.9)/0.1)+1.0)/2.0;
								} else {
									projdata = 0; 
								}
							/*
							weight = SQR((x-g3x)/lenx)+SQR((y-g3y)/leny)+SQR((z-g3z)/lenz);
							//DEBUGPRINT1("Weight: %lf\n", weight);
							if(weight<1) {
								weight = 1;
							} else {
								weight = (1/3.0 - 1/weight)/(1/3.0 - 1.0);
							}	
							//DEBUGPRINT1("Weight: %lf\n", weight);
							projdata *= weight;							
							*/
							} 
							mrcPixelDataSet(out, x, y, z, data + projdata, mrcPixelRePart);
						}
					}
				}
				}
				}
				break;
			}
			default: {
				break;
			}
		}
	}
	if(linfo->flagDouble && linfo->mode==mrc2Dto3DModeFilteredBackProjection) {
		/* Perform RhoFiltering */
#ifdef DEBUG
		//mrcFileWrite(out, "/tmp/RawDataforDebug.mrc3d", "in main", 0);
#endif
		linfo->CounterForWeight = lmrcImageRhoFiltering2(out, Matrix, i, &linfo->rhoInfo, 1);
		if(NULL==linfo->CounterForWeight) {
			fprintf(stderr, "Counter is null.\n");
		}
	} else {
		lmrcImageDevidedByReal(out, num);
	}
	mrcStatDataSet(out, 0);
}

