/*
# pdbTrans.c  1.1
# The latest update : 07/13/96 at 11:39:21
#
#@(#) pdbTrans ver 1.1
#@(#) Created by 
#@(#)
#@(#) Usage : pdbTrans 
#@(#) Attention
#@(#)
*/
static char __sccs_id[] = "@(#)pdbTrans ver1.1; Date:96/07/13 @(#)";
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#undef DEBUG
#include "../inc/pdbFile.h"
#include "String.h"
#include "genUtil.h"
#include "Vector.h"
#include "Matrix3D.h"

void
pdbMatrixFileFormat(FILE* fpt)
{
	matrix3DFileFormat(fpt);
}
void
pdbMatrixFileRead(FILE* fpt, Matrix3D Matrix)
{
	matrix3DFileRead(fpt, Matrix);
}
void
pdbMatrixFileWrite(FILE* fpt, Matrix3D Matrix)
{
	matrix3DFileWrite(fpt, Matrix);
}

void
pdbTrans(pdbFile* pdb, Matrix3D Matrix)
{
	floatVector v;
	
	floatVectorInit(&v, 4);
	v.data[3] = 1.0;
	pdbFileTop(pdb);
	while(1) {
	  if(0==strncmp(pdb->PDB->Record, pdbRecordAtom,       PDB_FILE_RECORD_LENGTH)
	   ||0==strncmp(pdb->PDB->Record, pdbRecordHeteroAtom, PDB_FILE_RECORD_LENGTH)) {
		
		v.data[0] = pdb->PDB->Coord.x;
		v.data[1] = pdb->PDB->Coord.y;
		v.data[2] = pdb->PDB->Coord.z;

		matrix3DMultiplyVector(&v, Matrix);

		DEBUGPRINT3("%f %f %f\n", Matrix[3][0], Matrix[3][1], Matrix[3][2]);
		DEBUGPRINT2("x %f -> %f\n", pdb->PDB->Coord.x, v.data[0]);
		DEBUGPRINT2("y %f -> %f\n", pdb->PDB->Coord.y, v.data[1]);
		DEBUGPRINT2("z %f -> %f\n", pdb->PDB->Coord.z, v.data[2]);

	    pdb->PDB->Coord.x = v.data[0];
	    pdb->PDB->Coord.y = v.data[1];
	    pdb->PDB->Coord.z = v.data[2];

	  }
	  if(NULL==pdb->PDB->next) {
	    break;
	  } else {
	    pdb->PDB = pdb->PDB->next;
	  }    
	}
	floatVectorFree(&v);
}

