/*
# pdbFileRead.c  1.2
# The latest update : 07/23/96 at 14:28:35
#
#@(#) pdbFileRead ver 1.2
#@(#) Created by 
#@(#)
#@(#) Usage : pdbFileRead 
#@(#) Attention
#@(#)
*/
static char __sccs_id[] = "@(#)pdbFileRead ver1.2; Date:96/07/23 @(#)";
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "genUtil.h"
#include "Memory.h"
#include "../inc/pdbFile.h"

void
pdbFileRead(FILE* fpt, pdbFile* pdb)
{
	pdbFileParaTypeCharacter s[PDB_FILE_RECORD_FULL_LENGTH+3];
	pdbFileParaTypeCharacter* p;
	pdbFileParaTypeCharacter stmp[PDB_FILE_RECORD_FULL_LENGTH+3];
  	pdbFileParaTypeInteger   flag, nAtom;
  
  	flag = 0;
  	nAtom = 0;
  	fseek(fpt, 0L, SEEK_SET);  
  	while(NULL!=fgets(s, PDB_FILE_RECORD_FULL_LENGTH+2, fpt)) {
   		p = s;
    	while(NULL!=*p) {
      		if(*p=='\n') {
				*p = NULL;
				break;
      		}
      		p++;
    	}
    	s[PDB_FILE_RECORD_FULL_LENGTH] = '\0';
	    if(0==flag) {
			pdbFileNew(pdb);
   		   	flag++;
   		 } else {
			pdbFileAppend(pdb);
			flag++;
   		 }
#ifdef DEBUG
		 fprintf(stderr, "%ld\n", flag);
#endif
    	s[PDB_FILE_RECORD_FULL_LENGTH] = '\0';
    	strncpy(pdb->PDB->Record,     s, PDB_FILE_RECORD_LENGTH);
		if(pdbFileIsAtom(pdb)) {
      		strncpy(stmp, s+PDB_FILE_ATOM_NUMBER_START, PDB_FILE_ATOM_NUMBER_LENGTH);
        	*(stmp+PDB_FILE_ATOM_NUMBER_LENGTH) = NULL;
        	pdb->PDB->AtomSerialNumber = atoi(stmp); *stmp = NULL;
      		strncpy(pdb->PDB->AtomName, s+PDB_FILE_ATOM_NAME_START,   PDB_FILE_ATOM_NAME_LENGTH);
      		pdb->PDB->LocationIndicator = *(s+PDB_FILE_LOCATION_START);
      		strncpy(pdb->PDB->ResidueName, s+PDB_FILE_RESIDUE_START,   PDB_FILE_RESIDUE_LENGTH);
      		pdb->PDB->ChainIdentifier = *(s+PDB_FILE_CHAIN_IDENT_START);
      		strncpy(stmp, s+PDB_FILE_RESNUM_START, PDB_FILE_RESNUM_LENGTH);
        	*(stmp+PDB_FILE_RESNUM_LENGTH) = NULL;      
        	pdb->PDB->ResidueSequenceNumber = atoi(stmp); *stmp = NULL;
      		pdb->PDB->InsertionCode = *(s+PDB_FILE_INSERTION_START);
      		strncpy(stmp, s+PDB_FILE_X_START, PDB_FILE_X_LENGTH);
        	*(stmp+PDB_FILE_X_LENGTH) = NULL;      
        	pdb->PDB->Coord.x = atof(stmp); *stmp = NULL;
      		strncpy(stmp, s+PDB_FILE_Y_START, PDB_FILE_Y_LENGTH);
       		*(stmp+PDB_FILE_Y_LENGTH) = NULL;            
        	pdb->PDB->Coord.y = atof(stmp); *stmp = NULL;
      		strncpy(stmp, s+PDB_FILE_Z_START, PDB_FILE_Z_LENGTH);
        	*(stmp+PDB_FILE_Z_LENGTH) = NULL;            
        	pdb->PDB->Coord.z = atof(stmp); *stmp = NULL;
      		strncpy(stmp, s+PDB_FILE_OCCUPANCY_START, PDB_FILE_OCCUPANCY_LENGTH);
        	*(stmp+PDB_FILE_OCCUPANCY_LENGTH) = NULL;            
        	pdb->PDB->Occupancy = atof(stmp); *stmp = NULL;
      		strncpy(stmp, s+PDB_FILE_TEMPERATURE_START, PDB_FILE_TEMPERATURE_LENGTH);
        	*(stmp+PDB_FILE_TEMPERATURE_LENGTH) = NULL;            
        	pdb->PDB->TemperatureFactor = atof(stmp); *stmp = NULL;
      		strncpy(stmp, s+PDB_FILE_FOOT_START, PDB_FILE_FOOT_LENGTH);
        	*(stmp+PDB_FILE_FOOT_LENGTH) = NULL;            
        	pdb->PDB->FootnoteNumber    = atol(stmp); *stmp = NULL;
      		strncpy(pdb->PDB->Footnote, s+PDB_FILE_FOOTNOTE_START, PDB_FILE_FOOTNOTE_LENGTH);
      		if(nAtom<pdb->PDB->AtomSerialNumber) {
        		nAtom = pdb->PDB->AtomSerialNumber;
			} else {
				nAtom++;
			}
    	} else {
        	strncpy(pdb->PDB->FullRecord, s, PDB_FILE_RECORD_FULL_LENGTH);
    	}
    	s[0] = '\0';
  	}
  	pdb->nAtom = nAtom;
    pdbSecondaryStructureSetFromPDB(pdb, &(pdb->second));	
}
