/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% lmrcImageWindowing ver %I%
#%Z% Created by 
#%Z%
#%Z% Usage : lmrcImageWindowing 
#%Z% Attention
#%Z%
*/


static char __sccs_id[] = "%Z%lmrcImageWindowing ver%I%; Date:%D% %Z%";
#include <math.h>
#define DEBUG
#include "genUtil.h"

#include "../inc/mrcImage.h"
#include "lmrcImageWindowing.h"

extern void __lmrcImageWindowingMode0(mrcImage* dst, mrcImage* src, lmrcImageWindowingInfo* info, long mode);
extern void __lmrcImageWindowingMode1(mrcImage* dst, mrcImage* src, lmrcImageWindowingInfo* info, long mode);
extern void __lmrcImageWindowingMode2(mrcImage* dst, mrcImage* src, lmrcImageWindowingInfo* info, long mode);

void
lmrcImageWindowing(mrcImage* dst, mrcImage* src, 
	lmrcImageWindowingInfo* info,
	long mode)
{
	switch(mode&0xf0) {
		case 0x00: {
			info->Offset = 0;
			break;
		}
		case 0x10: {
			info->Offset = src->HeaderAMean;
			break;
		}
		default: {
			break;
		 }
	}
	switch(mode&0xf) {
		case 0: {
			__lmrcImageWindowingMode0(dst, src, info, mode>>16);
			break;
		}
		case 1: {
			__lmrcImageWindowingMode1(dst, src, info, mode>>16);
			break;
		}
		case 2: {
			__lmrcImageWindowingMode2(dst, src, info, mode>>16);
			break;
		}
		default: {
			fprintf(stderr, "Not supported mode : %ld\n", mode>>16);
			break;
		}
	}
}

void
lmrcImageWindowingModePrint(FILE* fpt)
{
	fprintf(stderr, "0: 90% windowing:         fixed.   \n");
	fprintf(stderr, "1: Wy: Settings:          variable.\n");
	fprintf(stderr, "2: WxMax and Wx                    \n");
	fprintf(stderr, "   WyMax and Wy Settings: variables\n");
	fprintf(stderr, "           x/Nx < WxMax   or    1-WxMax < x/Nx           : 0 \n");
	fprintf(stderr, "   WxMax < x/Nx < Wx      or    1-Wx    < x/Nx < 1-WxMax : cos window  \n");
	fprintf(stderr, "                  Wx   < x/Nx < 1-Wx                     : 1\n");
	fprintf(stderr, "   Wy and WyMax are also used for windowing in the similar manner.\n");
	fprintf(stderr, "+0 : To Zero.  \n");
	fprintf(stderr, "+16: Contrast down around mean. \n");
}
void 
__lmrcImageWindowingMode0(mrcImage* dst, mrcImage* src, lmrcImageWindowingInfo* info, long mode)
{
	mrcImageParaTypeReal x, y, z;
	double data;
	double offset;
	double weightx;
	double weighty;

	if(src->HeaderN.z!=1) {
		fprintf(stderr, "Not supported N.z : %ld\n", src->HeaderN.z);
		return;
	}
	for(x=0; x<src->HeaderN.x; x++) {
		for(y=0; y<src->HeaderN.y; y++) {
			mrcPixelDataGet(src, x, y, 0.0, &data, mrcPixelMag, mrcPixelHowNearest);
	
			if(0.1*src->HeaderN.x < x && x < 0.9*src->HeaderN.x) {
				weightx = 1;	
			} else if(x < 0.1*src->HeaderN.x) {
				weightx = (0.5 - 0.5*cos(M_PI*x/(0.1*src->HeaderN.x)));
			} else if(0.9*src->HeaderN.x < x) {
				weightx = (0.5 + 0.5*cos(M_PI*(x-0.9*src->HeaderN.x)/(0.1*src->HeaderN.x)));
			}
			if(0.1*src->HeaderN.y < y && y < 0.9*src->HeaderN.y) {
				weighty = 1;
			} else if(y < 0.1*src->HeaderN.y) {
				weighty = (0.5 - 0.5*cos(M_PI*y/(0.1*src->HeaderN.y)));
			} else if(0.9*src->HeaderN.y < y) {
				weighty = (0.5 + 0.5*cos(M_PI*(y-0.9*src->HeaderN.y)/(0.1*src->HeaderN.y)));
			}
			data = weightx*weighty*(data - info->Offset) + info->Offset;	
			mrcPixelDataSet(dst, x, y, 0.0, data, mrcPixelMag);
		}
	}
}

void 
__lmrcImageWindowingMode1(mrcImage* dst, mrcImage* src, lmrcImageWindowingInfo* info, long mode)
{
	mrcImageParaTypeReal x, y, z;
	double data;

	if(src->HeaderN.z!=1) {
		fprintf(stderr, "Not supported N.z : %ld\n", src->HeaderN.z);
		return;
	}
	for(x=0; x<src->HeaderN.x; x++) {
		for(y=0; y<src->HeaderN.y; y++) {
			mrcPixelDataGet(src, x, y, 0.0, &data, mrcPixelMag, mrcPixelHowNearest);
			
			if(info->flagWy) {
				if(src->HeaderN.y/info->Wy < y) {
					data = src->HeaderAMean;
				}
			}

			mrcPixelDataSet(dst, x, y, 0.0, data, mrcPixelMag);
		}
	}
}

void 
__lmrcImageWindowingMode2(mrcImage* dst, mrcImage* src, lmrcImageWindowingInfo* info, long mode)
{
	mrcImageParaTypeReal x, y, z;
	double data;
	double weightx, weighty;
	double Wx, Wy, WxMax, WyMax;

	if(src->HeaderN.z!=1) {
		fprintf(stderr, "Not supported N.z : %ld\n", src->HeaderN.z);
		return;
	}

	if(!info->flagWxMax) {
		WxMax = 0;	
	} else {
		WxMax = info->WxMax*src->HeaderN.x;	
	}

	if(!info->flagWyMax) {
		WyMax = 0;	
	} else {
		WyMax = info->WyMax*src->HeaderN.y;	
	}

	if(!info->flagWx) {
		Wx= 0.1;	
	} else {
		Wx = info->Wx;	
	}
	Wx *= src->HeaderN.x;

	if(!info->flagWy) {
		Wy= 0.1;
	} else {
		Wy = info->Wy;
	}
	Wy *= src->HeaderN.y;
	DEBUGPRINT4("Wx %f %f  Wy %f %f\n",Wx, WxMax, Wy, WyMax );
	for(x=0; x<src->HeaderN.x; x++) {
		for(y=0; y<src->HeaderN.y; y++) {
			mrcPixelDataGet(src, x, y, 0.0, &data, mrcPixelMag, mrcPixelHowNearest);
	
			if(x < WxMax || src->HeaderN.x-WxMax < x) {
				weightx = 0;
			} else if(WxMax <=x && x <= Wx ) {
				weightx = 0.5*(cos((Wx - x)/(Wx - WxMax)*M_PI)+1.0);
			} else if(src->HeaderN.x - Wx <= x && x <= src->HeaderN.x - WxMax) {	
				weightx = 0.5*(cos((x - (src->HeaderN.x - Wx ))/(Wx - WxMax)*M_PI)+1.0);
			} else {
				weightx = 1;	
			}
			if(y < WyMax || src->HeaderN.y-WyMax < y) {
				weighty = 0;
			} else if(WyMax<=y && y <= Wy ) {
				weighty = 0.5*(cos((Wy - y)/(Wy - WyMax)*M_PI)+1.0);
			} else if(src->HeaderN.y - Wy <= y && y <= src->HeaderN.y - WyMax) {	
				weighty = 0.5*(cos((y - (src->HeaderN.y - Wy ))/(Wy - WyMax)*M_PI)+1.0);
			} else {
				weighty = 1;	
			}
			data = weightx*weighty*(data - info->Offset) + info->Offset;	
			mrcPixelDataSet(dst, x, y, 0.0, data, mrcPixelMag);
		}
	}
}

