#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Optional  :In: InputList\n");
    fprintf(stderr, "    [-I[nput]            In2                 (NULL      )In2Var              (NULL      )In2N                (0         )] :Optional  :In: Average Variable N\n");
    fprintf(stderr, "    [-Nor[malizingParameter]NorA                (0.0       )NorB                (1.0       )] :Optional  :In: A + B*x: NormalizingParameter\n");
    fprintf(stderr, "    [-r[ef]              Ref                 (NULL      )] :Optional  :Ref: InputList\n");
    fprintf(stderr, "    [-R[ef]              Ref2                (NULL      )Ref2Var             (NULL      )Ref2N               (0         )] :Optional  :Ref: Average Variable N\n");
    fprintf(stderr, "    [-Nor[malizingParameter]RNorARef             (0.0       )NorBRef             (1.0       )] :Optional  :In: A + B*x: NormalizingParameter for Ref\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Optional  :Output: Probability\n");
    fprintf(stderr, "    [-t[Value]           OutT                (NULL      )] :Optional  :Output: t-value\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
