/*
# mrcImageRotation3D : $Revision$  
# $Date$ 
# Created by $Author$
# Usage : mrcImageRotation3D
# Attention
#   $Loccker$
#  	$State$ 
#
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>                  
#define GLOBAL_DECLARATION
#include "../inc/config.h"

#define DEBUG
#include "genUtil.h"
#include "mrcImage.h"

/*
Example:
typedef struct lmrcImageRotation3DInfo {
	float a;
	int   b;
} lmrcImageRotation3DInfo;

typedef enum lmrcImageRotation3DMode {
	a=0,
	b=1
} lmrcImageRotation3DMode;
*/

int
main(int argc, char* argv[]) 
{
	mrcImage in;
	mrcImage out;
	mrcImageRotation3DInfo info;

	init0(&info);
    argCheck(&info, argc, argv);
    init1(&info);

	DEBUGPRINT("Program Start\n");
	mrcFileRead(&in, info.In, "in main", 0);

	lmrcImageRotation3DFollowingEulerAngle(&out, &in, 
		 	info.EulerAngle, 
		 	info.Rot1*RADIAN, 
			info.Rot2*RADIAN, 
			info.Rot3*RADIAN, 
			info.Mode, info.mode);

	mrcFileWrite(&out, info.Out, "in main", 0);
	exit(EXIT_SUCCESS);
}

void
additionalUsage()
{
	fprintf(stderr, "----- Additional Usage -----\n");
	fprintf(stderr, "-m \n");
	fprintf(stderr, " 0: padding 0 \n");
	fprintf(stderr, " 1: padding average \n");
	fprintf(stderr, " +0:  within ellipsoidal area.\n");
	fprintf(stderr, " +16: within square area.\n");

}
