/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% ctfforbayes ver %I%
#%Z% Created by 
#%Z%
#%Z% Usage : ctfforbayes 
#%Z% Attention
#%Z%
*/
static char __sccs_id[] = "%Z%ctfforbayes ver%I%; Date:%D% %Z%";


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include "eosBayes.h"
#include "../inc/ctfInfo.h"
#include "./ctffuncforbayes.h"




#define DEBUG
#undef DEBUG2
#include "genUtil.h"
#include "String.h"



void ctfforbayesInit(FILE* fpt, ctfforbayes* ctf, int mode){

	char s[1024];

	ctf->n = 0;

	while(NULL != __getStringData(s,"In ctfforbayesInit",fpt,stdout,3)){
		ctf->n++;
	}

	DEBUGPRINT1("ctf.n:%d\n",ctf->n);

	ctf->R = (float*)malloc(sizeof(float)*ctf->n);
//	ctf->I = (float*)malloc(sizeof(float)*ctf->n);
//	ctf->Ii = (float**)malloc(sizeof(float*)*ctf->n);

	fseek(fpt,0,SEEK_SET);

}


void intensityforbayesInit(intensityforbayes* intensity, int filenum, int Inum){

  int i;

  intensity->normI = (float**)malloc(sizeof(float*)*filenum);
  intensity->logI = (float**)malloc(sizeof(float*)*filenum);

  for(i=0;i<filenum;i++){
	intensity->normI[i] = (float*)malloc(sizeof(float)*Inum);
	intensity->logI[i] = (float*)malloc(sizeof(float)*Inum);
  }

  intensity->normII = (float**)malloc(sizeof(float*)*Inum);
  intensity->logII = (float**)malloc(sizeof(float*)*Inum);

  DEBUGPRINT2("Intensityinit finitsh! filenum:%d Inum:%d\n",filenum,Inum);

}



void spatialfrequencyRead(FILE* fpt, ctfforbayes* ctf, float rmax, float rmin, int mode){

	int i;
	char s[1024];
	
	i=0;
	while(NULL != __getStringData(s,"In spatialfrequencyRead",fpt,stdout,3)){
		ctf->R[i] = atof(s);
		i++; 
	}

	ctf->rmax = rmax;
	ctf->rmin = rmin;

	DEBUGPRINT2("Rmax:%f Rmin:%f\n", ctf->rmax,ctf->rmin);

}


void intensityRead(char* filename, intensityforbayes* intensity, int count, int mode){
	FILE* fin;
	int i;
	char s[1024];

	if( NULL == (fin = fopen(filename, "r"))){
		DEBUGPRINT1("%s was not opend\n",filename);
		exit(EXIT_FAILURE);
	}

	i=0;
	while(NULL != __getStringData(s,"In IntensityRead",fin,stdout,3)){
		intensity->normI[count][i] = atof(s);
		intensity->logI[count][i] = log(intensity->normI[count][i]);
		i++;
	}

	fclose(fin);

	DEBUGPRINT1("Intensity read!!: %dtimes\n",count+1);

}


void intensitySet(ctfforbayes* ctf, intensityforbayes intensity, int count, int mode){
  
  switch(mode){

  case 0:
	/*Normal*/
	DEBUGPRINT("----Intensity mode Normal----\n");
	  ctf->I = intensity.normI[count];
	  ctf->Ii = intensity.normII;
	break;

  case 1:
	/*Log*/
	DEBUGPRINT("----Intensity mode Log----\n");
	  ctf->I = intensity.logI[count];
	  ctf->Ii = intensity.logII;
	break;
	
  default:

	fprintf(stderr,"\n");
	break;

  }

}



void ctfFunctionforbayes(ctfforbayes* ctf, intensityforbayes* intensity, eosBayesDistribution* d, ctfInfo* info, int numLikelihood, int count, int mode){

	float S;
	float N;
	float k;
	float CTF;
	float MTF;
	float A;
	float B;


	int   length;

	int   i;
	int   j;

	int*  L;

	DEBUGPRINT("In ctf\n");

	length = 1;
	for(i=0;i<numLikelihood;i++){
	  length *= d[i].n;
	}
	
	//DEBUGPRINT("L malloc\n");
	
	L = (int *)malloc(sizeof(int)*numLikelihood);
	
	//DEBUGPRINT("L malloc\n");
	
	for(i=0;i<ctf->n;i++){
	  
	  //ctf->Ii[i] = (float *)malloc(sizeof(float)*length); 
	  intensity->normII[i] = (float *)malloc(sizeof(float)*length);
	  intensity->logII[i] = (float *)malloc(sizeof(float)*length);
	  //DEBUGPRINT("Ii malloc\n");

	  for(j=0;j<length;j++){
		
		eosBayesloop(d,L,numLikelihood,j);
		
		//DEBUGPRINT3("%d:%d:%d\n",L[0],L[1],L[2]);
		
		info->defocus = d[0].min+(d[0].delta*L[0]);
		S = d[1].min+(d[1].delta*L[1]);
		N = d[2].min+(d[2].delta*L[2]);
		CTF = ctfFunction(info, ctf->R[i], 0);

		/*value check*/
#ifdef DEBUG2
		ctfforbayescheckRvsValue("./data/CTF", ctf->R[i], CTF, count);
#endif

		MTF = MTFFunctionforbayes(ctf->R[i], 0, 0);
		//DEBUGPRINT1("MTF:%f\n",MTF);

		switch(mode){

		case 0:
		  //DEBUGPRINT("----ctfmode 0----\n");
		  A = S;
		  break;
		  
		case 1:
		  //DEBUGPRINT("----ctfmode 1----\n");
		  k = d[3].min+(d[3].delta*L[3]);
		  A = S*exp(-(k*k)*(ctf->R[i]*ctf->R[i]));
		  break;

		default:
		  fprintf(stderr,"\n");
		  break;

		}
		
		B = N;

		intensity->normII[i][j] = (CTF*CTF*A+B)*MTF;
		intensity->logII[i][j]  = log(intensity->normII[i][j]);

	  }
	  
	}
	
	free(L);
	
}


float MTFFunctionforbayes(float R, float m, int mode){
  
  float MTF;
  
  switch(mode){
	
  case 0:
	MTF = exp(-(m*R));
	break;

  default:
	fprintf(stderr,"");
	break;

  }

  return MTF;
  
}
