/*
 * $Id: ScoreActivity.java 16 2011-09-03 15:39:22Z lailai $
 */

package net.lailai.android.english.word.learning;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.graphics.Color;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;

public class ScoreActivity extends Activity {

	private TableLayout tableLayout = null;
	private int QNo = 0;
	private TextView textView6 = null;
	private TextView textView7 = null;

	/* ( Javadoc)
	 * @see android.app.Activity#onCreate(android.os.Bundle)
	 */
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		showScore();
	}

	/* ( Javadoc)
	 * @see android.app.Activity#onCreateOptionsMenu(android.view.Menu)
	 */
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		super.onCreateOptionsMenu(menu);
		MenuInflater menuInflater = getMenuInflater();
		menuInflater.inflate(R.menu.menu, menu);
		return true;
	}

	/* ( Javadoc)
	 * @see android.app.Activity#onOptionsItemSelected(android.view.MenuItem)
	 */
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		super.onOptionsItemSelected(item);
		switch (item.getItemId()) {
		case R.id.clear:
			popupConfirmScoreClear();
			return true;
		case R.id.help:
			Intent intent = new Intent(ScoreActivity.this, HelpActivity.class);
			startActivity(intent);
			return true;
		case R.id.exit:
			moveTaskToBack(true);
		default:
			break;
		}
		return false;
	}

	private void showScore() {
		setContentView(R.layout.score);

		// {^
		Button Question = (Button)findViewById(R.id.button1);
		Question.setText("");
		Question.setOnClickListener(new View.OnClickListener() {
			
			@Override
			public void onClick(View v) {
				finish();
			}
		});

		// 
		Bundle extras = getIntent().getExtras();
		int One = 0;
		int Two = 0;
		QNo = Integer.parseInt((String)extras.getCharSequence("QUESTION_NO"));
		tableLayout = (TableLayout)findViewById(R.id.tableLayout1);
		for (int i = 0; i < 300; i++) {
			TableRow tableRow = new TableRow(this);
			int j = 0;
			for (j = 0; j < 20; j++) {
				ImageView imageView = new ImageView(this);
				if (PlayData.getScore(i * 20 + j).equals("2")) {
					imageView.setBackgroundColor(Color.RED);
					Two++;
				} else if (PlayData.getScore(i * 20 + j).equals("1")) {
					imageView.setBackgroundColor(Color.YELLOW);
					One++;
				} else if (PlayData.getScore(i * 20 + j).equals("0")) {
					imageView.setBackgroundColor(Color.GREEN);
				}
				if (i * 20 + j == QNo - 1) {
					imageView.setBackgroundColor(Color.WHITE);
				}
				tableRow.addView(imageView, new TableRow.LayoutParams(20, 20));
			}
			if (i % 10 == 9) {
				TextView textView = new TextView(this);
				textView.setText(String.valueOf(i * 20 + j));
				textView.setGravity(Gravity.CENTER_VERTICAL);
				textView.setTextSize(TypedValue.COMPLEX_UNIT_PX, 18.0f);
				tableRow.addView(textView, new TableRow.LayoutParams(TableRow.LayoutParams.WRAP_CONTENT, 20));
			}
			tableLayout.addView(tableRow, new TableLayout.LayoutParams(TableLayout.LayoutParams.FILL_PARENT, TableLayout.LayoutParams.WRAP_CONTENT));
		}

		// 
		TextView textView = (TextView)findViewById(R.id.textView1);
		textView.setText(": 2ł(NA)");
		textView6 = (TextView)findViewById(R.id.textView6);
		textView6.setText(Two + " ");
		TextView textView2 = (TextView)findViewById(R.id.textView2);
		textView2.setText(": 1ł");
		textView7 = (TextView)findViewById(R.id.textView7);
		textView7.setText(One + " ");
		TextView textView3 = (TextView)findViewById(R.id.textView3);
		textView3.setText(": ܂łĂȂ");
		TextView textView4 = (TextView)findViewById(R.id.textView4);
		textView4.setText(": ݂̖");
		TextView textView5 = (TextView)findViewById(R.id.textView5);
		textView5.setText(": o͈(ʓ|)");
	}

	public void popupConfirmScoreClear() {
		AlertDialog.Builder adb = new AlertDialog.Builder(this);
		adb.setTitle(R.string.warning);
		adb.setMessage(R.string.confirm_score_clear);
		adb.setIcon(android.R.drawable.ic_dialog_alert);
		adb.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
			
			@Override
			public void onClick(DialogInterface dialog, int which) {
				clearPreference();
				showScore();
			}
		});
		adb.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() {
			
			@Override
			public void onClick(DialogInterface dialog, int which) {
			}
		});
		adb.show();
	}

	private void loadPreference() {
		PlayData.clearData();
		SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences(PlayData.getContext());
		for (int i = 0; i < EnglishWord.getWordCount(); i++) {
			PlayData.setScore(i, sharedPreferences.getString(String.valueOf(i + 1), "0"));
			if (!PlayData.getScore(i).equals("2")) {
				PlayData.addData(new Integer(i + 1));
			}
		}
	}

	private void clearPreference() {
		SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this);
		Editor ed = sp.edit();
		for (int i = 0 ; i < EnglishWord.getWordCount(); i++) {
			ed.putString(String.valueOf(i + 1), "0");
			ed.putLong(String.valueOf(i + 1) + "_time", 0l);
		}
		ed.commit();
		loadPreference();
	}
}
