/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.xml;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class RomAttributeParser {
    private RomAttributeParser() {
    }

    public static int parseEndian(String string) {
        if (string.equalsIgnoreCase("big") || string.equalsIgnoreCase(String.valueOf(2))) {
            return 2;
        }
        if (string.equalsIgnoreCase("little") || string.equalsIgnoreCase(String.valueOf(1))) {
            return 1;
        }
        return 1;
    }

    public static int parseHexString(String string) {
        if (string.equals("0")) {
            return 0;
        }
        if (string.length() > 2 && string.substring(0, 2).equalsIgnoreCase("0x")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        return Integer.parseInt(string, 16);
    }

    public static int parseStorageType(String string) {
        if (string.equalsIgnoreCase("float")) {
            return 99;
        }
        if (string.startsWith("uint")) {
            return Integer.parseInt(string.substring(4)) / 8;
        }
        return Integer.parseInt(string);
    }

    public static int parseScaleType(String string) {
        if (string.equalsIgnoreCase("inverse")) {
            return 2;
        }
        return 1;
    }

    public static int parseTableType(String string) {
        if (string.equalsIgnoreCase("3D") || string.equalsIgnoreCase(String.valueOf(3))) {
            return 3;
        }
        if (string.equalsIgnoreCase("2D") || string.equalsIgnoreCase(String.valueOf(2))) {
            return 2;
        }
        if (string.equalsIgnoreCase("X Axis") || string.equalsIgnoreCase("Static X Axis") || string.equalsIgnoreCase(String.valueOf(4))) {
            return 4;
        }
        if (string.equalsIgnoreCase("Y Axis") || string.equalsIgnoreCase("Static Y Axis") || string.equalsIgnoreCase(String.valueOf(5))) {
            return 5;
        }
        return 1;
    }

    public static int parseByteValue(byte[] byArray, int n, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        try {
            int n4 = 0;
            if (n == 2) {
                for (int i = 0; i < n3; ++i) {
                    n4 += (byArray[n2 + i] & 0xFF) << 8 * (n3 - i - 1);
                }
            } else {
                for (int i = 0; i < n3; ++i) {
                    n4 += (byArray[n2 + n3 - i - 1] & 0xFF) << 8 * (n3 - i - 1);
                }
            }
            return n4;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static byte[] parseIntegerValue(int n, int n2, int n3) {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        byte[] byArray2 = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            if (n2 == 2) {
                byArray2[i] = byArray[4 - n3 + i];
                continue;
            }
            byArray2[n3 - 1 - i] = byArray[4 - n3 + i];
        }
        return byArray2;
    }

    public static int parseFileSize(String string) throws NumberFormatException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.substring(string.length() - 2).equalsIgnoreCase("kb")) {
                return Integer.parseInt(string.substring(0, string.length() - 2)) * 1024;
            }
            if (string.substring(string.length() - 2).equalsIgnoreCase("mb")) {
                return Integer.parseInt(string.substring(0, string.length() - 2)) * 1024 * 1024;
            }
            throw new NumberFormatException();
        }
    }

    public static byte[] floatToByte(float f, int n) {
        byte[] byArray = new byte[4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, 4);
        if (n == 1) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        byteBuffer.putFloat(f);
        return byteBuffer.array();
    }

    public static float byteToFloat(byte[] byArray, int n) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, 4);
        if (n == 1) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        return byteBuffer.getFloat();
    }
}

