/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.maps.Table;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jdesktop.layout.GroupLayout;

public class TablePropertyPanel
extends JPanel {
    private static final long serialVersionUID = -5817685772039277602L;
    private JLabel byteToReal;
    private JLabel category;
    private JLabel coarse;
    private JTextArea description;
    private JLabel endian;
    private JLabel fine;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JLabel lblByteToReal;
    private JLabel lblCategory;
    private JLabel lblEndian;
    private JLabel lblRealToByte;
    private JLabel lblStorageAddress;
    private JLabel lblStorageSize;
    private JLabel lblTable;
    private JLabel lblUnit;
    private JLabel realToByte;
    private JLabel storageAddress;
    private JLabel storageSize;
    private JLabel tableName;
    private JLabel unit;
    private JLabel userLevel;

    public TablePropertyPanel(Table table) {
        this.initComponents();
        this.setVisible(true);
        this.tableName.setText(table.getName() + " (" + table.getType() + "D)");
        this.category.setText(table.getCategory());
        this.unit.setText(table.getScale().getUnit());
        this.byteToReal.setText(table.getScale().getExpression());
        this.realToByte.setText(table.getScale().getByteExpression());
        this.storageSize.setText("uint" + table.getStorageType() * 8);
        this.storageAddress.setText("0x" + Integer.toHexString(table.getStorageAddress()));
        if (table.getEndian() == 2) {
            this.endian.setText("big");
        } else {
            this.endian.setText("little");
        }
        this.description.setText(table.getDescription());
        this.fine.setText(table.getScale().getFineIncrement() + "");
        this.coarse.setText(table.getScale().getCoarseIncrement() + "");
        if (table.getUserLevel() == 1) {
            this.userLevel.setText("Beginner");
        } else if (table.getUserLevel() == 2) {
            this.userLevel.setText("Intermediate");
        } else if (table.getUserLevel() == 3) {
            this.userLevel.setText("Advanced");
        } else if (table.getUserLevel() == 4) {
            this.userLevel.setText("All");
        } else if (table.getUserLevel() == 5) {
            this.userLevel.setText("Debug");
        }
    }

    private TablePropertyPanel() {
    }

    private void initComponents() {
        this.lblTable = new JLabel();
        this.tableName = new JLabel();
        this.lblCategory = new JLabel();
        this.category = new JLabel();
        this.jPanel1 = new JPanel();
        this.lblUnit = new JLabel();
        this.unit = new JLabel();
        this.lblByteToReal = new JLabel();
        this.byteToReal = new JLabel();
        this.realToByte = new JLabel();
        this.lblRealToByte = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.coarse = new JLabel();
        this.fine = new JLabel();
        this.jPanel2 = new JPanel();
        this.lblStorageAddress = new JLabel();
        this.lblStorageSize = new JLabel();
        this.lblEndian = new JLabel();
        this.endian = new JLabel();
        this.storageSize = new JLabel();
        this.storageAddress = new JLabel();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.description = new JTextArea();
        this.jLabel5 = new JLabel();
        this.userLevel = new JLabel();
        this.setAutoscrolls(true);
        this.setFont(new Font("Tahoma", 0, 12));
        this.setInheritsPopupMenu(true);
        this.lblTable.setText("Table:");
        this.lblTable.setFocusable(false);
        this.tableName.setText("Tablename (3D)");
        this.tableName.setFocusable(false);
        this.lblCategory.setText("Category:");
        this.lblCategory.setFocusable(false);
        this.category.setText("Category");
        this.category.setFocusable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder("Conversion")));
        this.lblUnit.setText("Unit:");
        this.lblUnit.setFocusable(false);
        this.unit.setText("unit");
        this.unit.setFocusable(false);
        this.lblByteToReal.setText("Byte to Real:");
        this.lblByteToReal.setFocusable(false);
        this.byteToReal.setText("bytetoreal");
        this.byteToReal.setFocusable(false);
        this.realToByte.setText("realtobyte");
        this.realToByte.setFocusable(false);
        this.lblRealToByte.setText("Real to Byte:");
        this.lblRealToByte.setFocusable(false);
        this.jLabel1.setText("Coarse adjust:");
        this.jLabel2.setText("Fine adjust:");
        this.coarse.setText("coarse");
        this.fine.setText("fine");
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblUnit).add((Component)this.lblByteToReal).add((Component)this.lblRealToByte).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0, 14, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(2, 2, 2).add((Component)this.unit)).add((Component)this.byteToReal).add((Component)this.realToByte).add((Component)this.coarse).add((Component)this.fine)).add(27, 27, 27)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.unit).addPreferredGap(0).add((Component)this.byteToReal).addPreferredGap(0).add((Component)this.realToByte)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblUnit).addPreferredGap(0).add((Component)this.lblByteToReal).addPreferredGap(0).add((Component)this.lblRealToByte))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.coarse)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.fine))));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Storage"));
        this.lblStorageAddress.setText("Storage Address:");
        this.lblStorageAddress.setFocusable(false);
        this.lblStorageSize.setText("Storage Size:");
        this.lblStorageSize.setFocusable(false);
        this.lblEndian.setText("Endian:");
        this.lblEndian.setFocusable(false);
        this.endian.setText("little");
        this.endian.setFocusable(false);
        this.storageSize.setText("uint16");
        this.storageSize.setFocusable(false);
        this.storageAddress.setText("0x00");
        this.storageAddress.setFocusable(false);
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.lblStorageAddress).add((Component)this.lblStorageSize).add((Component)this.lblEndian)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.endian).add((Component)this.storageSize).add((Component)this.storageAddress)).addContainerGap(28, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.lblStorageSize).add((Component)this.storageSize)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.lblStorageAddress).add((Component)this.storageAddress)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.lblEndian).add((Component)this.endian)).addContainerGap(37, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Description"));
        this.jScrollPane1.setBorder(null);
        this.description.setBackground(new Color(236, 233, 216));
        this.description.setColumns(20);
        this.description.setEditable(false);
        this.description.setFont(new Font("Tahoma", 0, 11));
        this.description.setLineWrap(true);
        this.description.setRows(5);
        this.description.setText("Description");
        this.description.setWrapStyleWord(true);
        this.description.setBorder(null);
        this.description.setOpaque(false);
        this.description.setRequestFocusEnabled(false);
        this.jScrollPane1.setViewportView(this.description);
        GroupLayout groupLayout3 = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(2, (Component)this.jScrollPane1, -1, 360, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.jScrollPane1, -1, 102, Short.MAX_VALUE).addContainerGap()));
        this.jLabel5.setText("User Level:");
        this.userLevel.setText("Beginner");
        GroupLayout groupLayout4 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.lblCategory).add((Component)this.lblTable)).addPreferredGap(0).add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.category).add(110, 110, 110).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.userLevel)).add((Component)this.tableName, -1, 321, Short.MAX_VALUE))).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.tableName).add((Component)this.lblTable)).addPreferredGap(0).add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.lblCategory).add((Component)this.category).add((Component)this.jLabel5).add((Component)this.userLevel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout4.createParallelGroup(1, false).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jPanel3, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

