/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public final class LookAndFeelManager {
    private static final Logger LOGGER = Logger.getLogger(LookAndFeelManager.class);
    private static final String OS_NAME = "os.name";
    private static final String MAC_OS_X = "Mac OS X";
    private static final String LINUX = "Linux";

    private LookAndFeelManager() {
        throw new UnsupportedOperationException();
    }

    public static void initLookAndFeel() {
        try {
            if (LookAndFeelManager.isPlatform(MAC_OS_X)) {
                System.setProperty("apple.awt.rendering", "true");
                System.setProperty("apple.awt.brushMetalLook", "true");
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("apple.awt.window.position.forceSafeCreation", "true");
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", "RomRaider");
            }
            UIManager.setLookAndFeel(LookAndFeelManager.getLookAndFeel());
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Error loading system look and feel.", (Throwable)exception);
        }
    }

    private static boolean isPlatform(String string) {
        return System.getProperties().getProperty(OS_NAME).toLowerCase().contains(string.toLowerCase());
    }

    private static String getLookAndFeel() {
        if (LookAndFeelManager.isPlatform(LINUX)) {
            return UIManager.getCrossPlatformLookAndFeelClassName();
        }
        return UIManager.getSystemLookAndFeelClassName();
    }
}

