/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.comms.io.connection;

import com.romraider.io.connection.ConnectionManager;
import com.romraider.logger.ecu.comms.io.connection.LoggerConnection;
import com.romraider.logger.ecu.comms.io.protocol.LoggerProtocol;
import com.romraider.logger.ecu.comms.io.protocol.SSMLoggerProtocol;
import com.romraider.logger.ecu.comms.query.EcuInitCallback;
import com.romraider.logger.ecu.comms.query.EcuQuery;
import com.romraider.util.HexUtil;
import com.romraider.util.ParamChecker;
import java.util.Collection;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SSMLoggerConnection
implements LoggerConnection {
    private static final Logger LOGGER = Logger.getLogger(SSMLoggerConnection.class);
    private static final long SEND_TIMEOUT = 2000L;
    private final LoggerProtocol protocol = new SSMLoggerProtocol();
    private final ConnectionManager manager;

    public SSMLoggerConnection(ConnectionManager connectionManager) {
        ParamChecker.checkNotNull((Object)connectionManager, "manager");
        this.manager = connectionManager;
    }

    @Override
    public void ecuReset() {
        byte[] byArray = this.protocol.constructEcuResetRequest();
        LOGGER.debug((Object)("Ecu Reset Request  ---> " + HexUtil.asHex(byArray)));
        byte[] byArray2 = this.manager.send(byArray, 2000L);
        byte[] byArray3 = this.protocol.preprocessResponse(byArray, byArray2);
        LOGGER.debug((Object)("Ecu Reset Response <--- " + HexUtil.asHex(byArray3)));
        this.protocol.processEcuResetResponse(byArray3);
    }

    @Override
    public void ecuInit(EcuInitCallback ecuInitCallback) {
        byte[] byArray = this.protocol.constructEcuInitRequest();
        LOGGER.debug((Object)("Ecu Init Request  ---> " + HexUtil.asHex(byArray)));
        byte[] byArray2 = this.manager.send(byArray, 2000L);
        byte[] byArray3 = this.protocol.preprocessResponse(byArray, byArray2);
        LOGGER.debug((Object)("Ecu Init Response <--- " + HexUtil.asHex(byArray3)));
        this.protocol.processEcuInitResponse(ecuInitCallback, byArray3);
    }

    @Override
    public void sendAddressReads(Collection<EcuQuery> collection) {
        byte[] byArray = this.protocol.constructReadAddressRequest(collection);
        byte[] byArray2 = this.protocol.constructReadAddressResponse(collection);
        LOGGER.trace((Object)("ECU Request  ---> " + HexUtil.asHex(byArray)));
        this.manager.send(byArray, byArray2, 2000L);
        byte[] byArray3 = this.protocol.preprocessResponse(byArray, byArray2);
        LOGGER.trace((Object)("ECU Response <--- " + HexUtil.asHex(byArray3)));
        this.protocol.processReadAddressResponses(collection, byArray3);
    }

    @Override
    public void close() {
        this.manager.close();
    }
}

