/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.io.serial.connection;

import com.romraider.io.connection.ConnectionManager;
import com.romraider.io.connection.ConnectionProperties;
import com.romraider.io.serial.connection.SerialConnection;
import com.romraider.io.serial.connection.SerialConnectionImpl;
import com.romraider.util.HexUtil;
import com.romraider.util.ParamChecker;
import com.romraider.util.ThreadUtil;
import org.apache.log4j.Logger;

public final class SerialConnectionManager
implements ConnectionManager {
    private static final Logger LOGGER = Logger.getLogger(SerialConnectionManager.class);
    private final SerialConnection connection;

    public SerialConnectionManager(String string, ConnectionProperties connectionProperties) {
        ParamChecker.checkNotNullOrEmpty(string, "portName");
        ParamChecker.checkNotNull((Object)connectionProperties, "connectionProperties");
        this.connection = new SerialConnectionImpl(string, connectionProperties);
    }

    public void send(byte[] byArray, byte[] byArray2, long l) {
        ParamChecker.checkNotNull((Object)byArray, "request");
        ParamChecker.checkNotNull((Object)byArray, "response");
        this.connection.readStaleData();
        this.connection.write(byArray);
        while (this.connection.available() < byArray2.length) {
            ThreadUtil.sleep(1L);
            if (--l > 0L) continue;
            byte[] byArray3 = new byte[this.connection.available()];
            this.connection.read(byArray3);
            LOGGER.debug((Object)("Bad response (read timeout): " + HexUtil.asHex(byArray3)));
            break;
        }
        this.connection.read(byArray2);
    }

    public byte[] send(byte[] byArray, long l) {
        ParamChecker.checkNotNull((Object)byArray, "bytes");
        this.connection.readStaleData();
        this.connection.write(byArray);
        int n = 0;
        boolean bl = true;
        long l2 = System.currentTimeMillis();
        while (bl) {
            ThreadUtil.sleep(2L);
            if (this.connection.available() != n) {
                n = this.connection.available();
                l2 = System.currentTimeMillis();
            }
            bl = System.currentTimeMillis() - l2 < l;
        }
        return this.connection.readAvailable();
    }

    public void close() {
        this.connection.close();
    }
}

