/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.HashKey;
import javax.media.j3d.IllegalSceneGraphException;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.ImageComponentUpdateInfo;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.OrderedPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SwitchState;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Texture2DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

class BackgroundRetained
extends LeafRetained {
    static final int COLOR_CHANGED = 1;
    static final int IMAGE_CHANGED = 2;
    static final int GEOMETRY_CHANGED = 4;
    static final int BOUNDS_CHANGED = 8;
    static final int BOUNDINGLEAF_CHANGED = 16;
    static final int IMAGE_SCALE_CHANGED = 32;
    Color3f color = new Color3f(0.0f, 0.0f, 0.0f);
    ImageComponent2DRetained image = null;
    Texture2DRetained texture = null;
    int imageScaleMode = 0;
    Bounds applicationRegion = null;
    BoundingLeafRetained boundingLeaf = null;
    BranchGroup geometryBranch = null;
    Bounds transformedRegion = null;
    SetLiveState setLiveState = null;
    Locale cachedLocale = null;
    boolean inImmCtx = false;
    ArrayList lights = new ArrayList();
    ArrayList fogs = new ArrayList();
    ArrayList bgGeometryAtomList = new ArrayList();
    boolean bgGeometryAtomListDirty = true;
    GeometryAtom[] bgGeometryAtoms = null;
    static final int targetThreads = 4224;
    boolean isViewScoped = false;

    BackgroundRetained() {
        this.nodeType = 1;
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
    }

    final void initColor(Color3f color3f) {
        this.color.set((Tuple3f)color3f);
    }

    final void setColor(Color3f color3f) {
        this.initColor(color3f);
        if (this.source.isLive()) {
            this.sendMessage(1, new Color3f(color3f));
        }
    }

    final void initColor(float f, float f2, float f3) {
        this.color.x = f;
        this.color.y = f2;
        this.color.z = f3;
    }

    final void setColor(float f, float f2, float f3) {
        this.setColor(new Color3f(f, f2, f3));
    }

    final void getColor(Color3f color3f) {
        color3f.set((Tuple3f)this.color);
    }

    final void initImageScaleMode(int n) {
        this.imageScaleMode = n;
    }

    final void setImageScaleMode(int n) {
        this.initImageScaleMode(n);
        if (this.source.isLive()) {
            this.sendMessage(32, new Integer(n));
        }
    }

    final int getImageScaleMode() {
        return this.imageScaleMode;
    }

    final void initImage(ImageComponent2D imageComponent2D) {
        if (imageComponent2D == null) {
            this.image = null;
            this.texture = null;
            return;
        }
        if (imageComponent2D.retained != this.image) {
            int n;
            this.image = (ImageComponent2DRetained)imageComponent2D.retained;
            this.image.setEnforceNonPowerOfTwoSupport(true);
            switch (this.image.getNumberOfComponents()) {
                case 1: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 4;
                    break;
                }
                case 3: {
                    n = 5;
                    break;
                }
                case 4: {
                    n = 6;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            Texture2D texture2D = new Texture2D(1, n, imageComponent2D.getWidth(), imageComponent2D.getHeight());
            this.texture = (Texture2DRetained)texture2D.retained;
            this.texture.setUseAsRaster(true);
            this.texture.initImage(0, imageComponent2D);
        }
    }

    final void setImage(ImageComponent2D imageComponent2D) {
        if (this.source.isLive() && this.texture != null) {
            this.texture.clearLive(this.refCount);
            this.texture.removeUser(this);
        }
        this.initImage(imageComponent2D);
        if (this.source.isLive()) {
            if (this.texture != null) {
                this.texture.setLive(this.inBackgroundGroup, this.refCount);
                this.texture.addUser(this);
            }
            this.sendMessage(2, this.texture != null ? this.texture.mirror : null);
        }
    }

    final ImageComponent2D getImage() {
        return this.image == null ? null : (ImageComponent2D)this.image.source;
    }

    final void initGeometry(BranchGroup branchGroup) {
        this.geometryBranch = branchGroup;
    }

    final void setGeometry(BranchGroup branchGroup) {
        int n = 0;
        if (this.source.isLive()) {
            int n2;
            if (this.geometryBranch != null) {
                n += 2;
            }
            if (branchGroup != null) {
                n += 2;
            }
            J3dMessage[] j3dMessageArray = new J3dMessage[n];
            for (n2 = 0; n2 < n; ++n2) {
                j3dMessageArray[n2] = new J3dMessage();
            }
            n2 = 0;
            if (this.geometryBranch != null) {
                this.clearGeometryBranch((BranchGroupRetained)this.geometryBranch.retained);
                j3dMessageArray[n2].threads = 4224;
                j3dMessageArray[n2].type = 33;
                j3dMessageArray[n2].universe = this.universe;
                j3dMessageArray[n2].args[0] = this.setLiveState.ogList.toArray();
                j3dMessageArray[n2].args[1] = this.setLiveState.ogChildIdList.toArray();
                j3dMessageArray[n2].args[3] = this.setLiveState.ogCIOList.toArray();
                j3dMessageArray[n2].args[4] = this.setLiveState.ogCIOTableList.toArray();
                j3dMessageArray[++n2].threads = this.setLiveState.notifyThreads;
                j3dMessageArray[n2].type = 1;
                j3dMessageArray[n2].universe = this.universe;
                j3dMessageArray[n2].args[0] = this.setLiveState.nodeList.toArray();
                ++n2;
            }
            if (branchGroup != null) {
                this.setGeometryBranch((BranchGroupRetained)branchGroup.retained);
                j3dMessageArray[n2].threads = 4224;
                j3dMessageArray[n2].type = 32;
                j3dMessageArray[n2].universe = this.universe;
                j3dMessageArray[n2].args[0] = this.setLiveState.ogList.toArray();
                j3dMessageArray[n2].args[1] = this.setLiveState.ogChildIdList.toArray();
                j3dMessageArray[n2].args[2] = this.setLiveState.ogOrderedIdList.toArray();
                j3dMessageArray[n2].args[3] = this.setLiveState.ogCIOList.toArray();
                j3dMessageArray[n2].args[4] = this.setLiveState.ogCIOTableList.toArray();
                j3dMessageArray[++n2].threads = this.setLiveState.notifyThreads;
                j3dMessageArray[n2].type = 0;
                j3dMessageArray[n2].universe = this.universe;
                j3dMessageArray[n2].args[0] = this.setLiveState.nodeList.toArray();
            }
            VirtualUniverse.mc.processMessage(j3dMessageArray);
            this.setLiveState.reset(null);
        }
        this.initGeometry(branchGroup);
    }

    final BranchGroup getGeometry() {
        return this.geometryBranch;
    }

    final void initApplicationBounds(Bounds bounds) {
        this.applicationRegion = bounds != null ? (Bounds)bounds.clone() : null;
    }

    final void setApplicationBounds(Bounds bounds) {
        this.initApplicationBounds(bounds);
        if (this.boundingLeaf == null) {
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.threads = 4224;
            j3dMessage.type = 20;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(8);
            j3dMessage.args[2] = bounds != null ? bounds.clone() : null;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    final Bounds getApplicationBounds() {
        return this.applicationRegion != null ? (Bounds)this.applicationRegion.clone() : null;
    }

    void initApplicationBoundingLeaf(BoundingLeaf boundingLeaf) {
        this.boundingLeaf = boundingLeaf != null ? (BoundingLeafRetained)boundingLeaf.retained : null;
    }

    void setApplicationBoundingLeaf(BoundingLeaf boundingLeaf) {
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this);
        }
        if (boundingLeaf != null) {
            this.boundingLeaf = (BoundingLeafRetained)boundingLeaf.retained;
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this);
        } else {
            this.boundingLeaf = null;
        }
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 4224;
        j3dMessage.type = 20;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(16);
        if (this.boundingLeaf != null) {
            j3dMessage.args[2] = this.boundingLeaf.mirrorBoundingLeaf;
            j3dMessage.args[3] = null;
        } else {
            j3dMessage.args[2] = null;
            j3dMessage.args[3] = this.applicationRegion != null ? this.applicationRegion.clone() : null;
        }
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    BoundingLeaf getApplicationBoundingLeaf() {
        return this.boundingLeaf != null ? (BoundingLeaf)this.boundingLeaf.source : null;
    }

    void setInImmCtx(boolean bl) {
        this.inImmCtx = bl;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    void setGeometryBranch(BranchGroupRetained branchGroupRetained) {
        this.setLiveState.reset(this.locale);
        this.setLiveState.inBackgroundGroup = true;
        this.setLiveState.geometryBackground = this;
        this.setLiveState.currentTransforms[0] = new Transform3D[2];
        this.setLiveState.currentTransforms[0][0] = new Transform3D();
        this.setLiveState.currentTransforms[0][1] = new Transform3D();
        this.setLiveState.currentTransformsIndex[0] = new int[2];
        this.setLiveState.currentTransformsIndex[0][0] = 0;
        this.setLiveState.currentTransformsIndex[0][1] = 0;
        this.setLiveState.localToVworld = this.setLiveState.currentTransforms;
        this.setLiveState.localToVworldIndex = this.setLiveState.currentTransformsIndex;
        this.setLiveState.branchGroupPaths = new ArrayList();
        this.setLiveState.branchGroupPaths.add(new BranchGroupRetained[0]);
        this.setLiveState.orderedPaths = new ArrayList(1);
        this.setLiveState.orderedPaths.add(new OrderedPath());
        this.setLiveState.switchStates = new ArrayList(1);
        this.setLiveState.switchStates.add(new SwitchState(false));
        branchGroupRetained.setLive(this.setLiveState);
    }

    void clearGeometryBranch(BranchGroupRetained branchGroupRetained) {
        this.setLiveState.reset(this.locale);
        this.setLiveState.inBackgroundGroup = true;
        this.setLiveState.geometryBackground = this;
        branchGroupRetained.clearLive(this.setLiveState);
        branchGroupRetained.setParent(null);
        branchGroupRetained.setLocale(null);
    }

    void setLive(SetLiveState setLiveState) {
        super.doSetLive(setLiveState);
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("BackgroundRetained1"));
        }
        if (this.inBackgroundGroup) {
            throw new IllegalSceneGraphException(J3dI18N.getString("BackgroundRetained5"));
        }
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("BackgroundRetained6"));
        }
        if (this.geometryBranch != null) {
            BranchGroupRetained branchGroupRetained = (BranchGroupRetained)this.geometryBranch.retained;
            if (branchGroupRetained.inBackgroundGroup) {
                throw new IllegalSharingException(J3dI18N.getString("BackgroundRetained0"));
            }
            if (branchGroupRetained.parent != null) {
                throw new IllegalSharingException(J3dI18N.getString("BackgroundRetained3"));
            }
            if (branchGroupRetained.locale != null) {
                throw new IllegalSharingException(J3dI18N.getString("BackgroundRetained4"));
            }
            if (this.setLiveState == null) {
                this.setLiveState = new SetLiveState(this.universe);
                this.setLiveState.universe = this.universe;
            }
            this.setGeometryBranch((BranchGroupRetained)this.geometryBranch.retained);
            setLiveState.nodeList.addAll(this.setLiveState.nodeList);
            setLiveState.notifyThreads |= this.setLiveState.notifyThreads;
            setLiveState.ogList.addAll(this.setLiveState.ogList);
            setLiveState.ogChildIdList.addAll(this.setLiveState.ogChildIdList);
            setLiveState.ogOrderedIdList.addAll(this.setLiveState.ogOrderedIdList);
            this.setLiveState.reset(null);
        }
        if (setLiveState.viewScopedNodeList != null && setLiveState.viewLists != null) {
            setLiveState.viewScopedNodeList.add(this);
            setLiveState.scopedNodesViewList.add(setLiveState.viewLists.get(0));
        } else {
            setLiveState.nodeList.add(this);
        }
        if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
            setLiveState.switchTargets[0].addNode(this, 1);
        }
        this.switchState = (SwitchState)setLiveState.switchStates.get(0);
        if (this.boundingLeaf != null) {
            this.transformedRegion = this.boundingLeaf.mirrorBoundingLeaf.transformedRegion;
        } else if (this.applicationRegion != null) {
            this.transformedRegion = (Bounds)this.applicationRegion.clone();
            this.transformedRegion.transform(this.applicationRegion, this.getLastLocalToVworld());
        } else {
            this.transformedRegion = null;
        }
        this.cachedLocale = setLiveState.locale;
        if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
            setLiveState.transformTargets[0].addNode(this, 1);
            setLiveState.notifyThreads |= 0x2000;
        }
        setLiveState.notifyThreads |= 0x1080;
        if (this.texture != null) {
            this.texture.setLive(this.inBackgroundGroup, this.refCount);
        }
        super.markAsLive();
    }

    void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        if (setLiveState.viewScopedNodeList != null && setLiveState.viewLists != null) {
            setLiveState.viewScopedNodeList.add(this);
            setLiveState.scopedNodesViewList.add(setLiveState.viewLists.get(0));
        } else {
            setLiveState.nodeList.add(this);
        }
        if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
            setLiveState.transformTargets[0].addNode(this, 1);
            setLiveState.notifyThreads |= 0x2000;
        }
        if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
            setLiveState.switchTargets[0].addNode(this, 1);
        }
        if (this.geometryBranch != null) {
            BranchGroupRetained branchGroupRetained = (BranchGroupRetained)this.geometryBranch.retained;
            this.clearGeometryBranch((BranchGroupRetained)this.geometryBranch.retained);
            setLiveState.nodeList.addAll(this.setLiveState.nodeList);
            setLiveState.ogList.addAll(this.setLiveState.ogList);
            setLiveState.ogChildIdList.addAll(this.setLiveState.ogChildIdList);
            setLiveState.notifyThreads |= this.setLiveState.notifyThreads;
            this.setLiveState.reset(null);
            this.lights.clear();
            this.fogs.clear();
        }
        if (this.texture != null) {
            this.texture.clearLive(this.refCount);
        }
        setLiveState.notifyThreads |= 0x1080;
    }

    synchronized void updateImmediateMirrorObject(Object[] objectArray) {
        int n = (Integer)objectArray[1];
        if ((n & 8) != 0) {
            if (objectArray[2] != null) {
                this.transformedRegion = ((Bounds)objectArray[2]).copy(this.transformedRegion);
                this.transformedRegion.transform((Bounds)objectArray[2], this.getCurrentLocalToVworld());
            } else {
                this.transformedRegion = null;
            }
        } else if ((n & 0x10) != 0) {
            if (objectArray[2] != null) {
                this.transformedRegion = ((BoundingLeafRetained)objectArray[2]).transformedRegion;
            } else {
                Bounds bounds = (Bounds)objectArray[3];
                if (bounds != null) {
                    this.transformedRegion = bounds.copy(this.transformedRegion);
                    this.transformedRegion.transform(bounds, this.getCurrentLocalToVworld());
                } else {
                    this.transformedRegion = null;
                }
            }
        }
    }

    void updateBoundingLeaf() {
        if (this.boundingLeaf != null && this.boundingLeaf.mirrorBoundingLeaf.switchState.currentSwitchOn) {
            this.transformedRegion = this.boundingLeaf.mirrorBoundingLeaf.transformedRegion;
        } else if (this.applicationRegion != null) {
            this.transformedRegion = this.applicationRegion.copy(this.transformedRegion);
            this.transformedRegion.transform(this.applicationRegion, this.getCurrentLocalToVworld());
        } else {
            this.transformedRegion = null;
        }
    }

    void updateImmediateTransformChange() {
        if (this.boundingLeaf == null && this.applicationRegion != null) {
            this.transformedRegion = this.applicationRegion.copy(this.transformedRegion);
            this.transformedRegion.transform(this.applicationRegion, this.getCurrentLocalToVworld());
        }
    }

    final void sendMessage(int n, Object object) {
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 4224;
        j3dMessage.universe = this.universe;
        j3dMessage.type = 20;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void addBgGeometryAtomList(GeometryAtom geometryAtom) {
        this.bgGeometryAtomList.add(geometryAtom);
        this.bgGeometryAtomListDirty = true;
    }

    void removeBgGeometryAtomList(GeometryAtom geometryAtom) {
        this.bgGeometryAtomList.remove(this.bgGeometryAtomList.indexOf(geometryAtom));
        this.bgGeometryAtomListDirty = true;
    }

    GeometryAtom[] getBackgroundGeometryAtoms() {
        if (this.bgGeometryAtomListDirty) {
            int n = this.bgGeometryAtomList.size();
            if (n == 0) {
                this.bgGeometryAtoms = null;
            } else {
                this.bgGeometryAtoms = new GeometryAtom[n];
                for (int i = 0; i < this.bgGeometryAtoms.length; ++i) {
                    this.bgGeometryAtoms[i] = (GeometryAtom)this.bgGeometryAtomList.get(i);
                }
                this.bgGeometryAtomListDirty = false;
            }
        }
        return this.bgGeometryAtoms;
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        if (this.applicationRegion != null) {
            this.applicationRegion.transform(transformGroupRetained.transform);
        }
    }

    void notifyImageComponentImageChanged(ImageComponentRetained imageComponentRetained, ImageComponentUpdateInfo imageComponentUpdateInfo) {
    }

    void getMirrorObjects(ArrayList arrayList, HashKey hashKey) {
        arrayList.add(this);
    }
}

