/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.lexicon;

import com.sun.speech.freetts.lexicon.LetterToSound;
import com.sun.speech.freetts.util.BulkTimer;
import com.sun.speech.freetts.util.Utilities;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class LetterToSoundImpl
implements LetterToSound {
    static final String TOTAL = "TOTAL";
    static final String INDEX = "INDEX";
    static final String STATE = "STATE";
    static final String PHONE = "PHONE";
    protected boolean tokenizeOnLoad = false;
    protected boolean tokenizeOnLookup = false;
    private static final int MAGIC = -559038737;
    private static final int VERSION = 1;
    private Object[] stateMachine = null;
    private int numStates = 0;
    private static final int WINDOW_SIZE = 4;
    private char[] fval_buff = new char[8];
    protected HashMap letterIndex;
    private static List phonemeTable;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LetterToSoundImpl(URL ltsRules, boolean binary) throws IOException {
        BulkTimer.LOAD.start("LTS");
        InputStream is = ltsRules.openStream();
        if (binary) {
            this.loadBinary(is);
        } else {
            this.loadText(is);
        }
        is.close();
        BulkTimer.LOAD.stop("LTS");
    }

    private void loadText(InputStream is) throws IOException {
        String tokenize = Utilities.getProperty("com.sun.speech.freetts.lexicon.LTSTokenize", "load");
        this.tokenizeOnLoad = tokenize.equals("load");
        this.tokenizeOnLookup = tokenize.equals("lookup");
        this.letterIndex = new HashMap();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = reader.readLine();
        while (line != null) {
            if (!line.startsWith("***")) {
                this.parseAndAdd(line);
            }
            line = reader.readLine();
        }
    }

    private void loadBinary(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        if (dis.readInt() != -559038737) {
            throw new Error("Bad LTS binary file format");
        }
        if (dis.readInt() != 1) {
            throw new Error("Bad LTS binary file version");
        }
        int phonemeTableSize = dis.readInt();
        phonemeTable = new ArrayList(phonemeTableSize);
        for (int i = 0; i < phonemeTableSize; ++i) {
            String phoneme = dis.readUTF();
            phonemeTable.add(phoneme);
        }
        int letterIndexSize = dis.readInt();
        this.letterIndex = new HashMap();
        for (int i = 0; i < letterIndexSize; ++i) {
            char c = dis.readChar();
            int index = dis.readInt();
            this.letterIndex.put(Character.toString(c), new Integer(index));
        }
        int stateMachineSize = dis.readInt();
        this.stateMachine = new Object[stateMachineSize];
        for (int i = 0; i < stateMachineSize; ++i) {
            int type = dis.readInt();
            if (type == 2) {
                this.stateMachine[i] = FinalState.loadBinary(dis);
                continue;
            }
            if (type == 1) {
                this.stateMachine[i] = DecisionState.loadBinary(dis);
                continue;
            }
            throw new Error("Unknown state type in LTS load");
        }
    }

    protected void parseAndAdd(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        String type = tokenizer.nextToken();
        if (type.equals(STATE) || type.equals(PHONE)) {
            this.stateMachine[this.numStates] = this.tokenizeOnLoad ? this.getState(type, tokenizer) : line;
            ++this.numStates;
        } else if (type.equals(INDEX)) {
            Integer index = new Integer(tokenizer.nextToken());
            if (index != this.numStates) {
                throw new Error("Bad INDEX in file.");
            }
            String c = tokenizer.nextToken();
            this.letterIndex.put(c, index);
        } else if (type.equals(TOTAL)) {
            this.stateMachine = new Object[Integer.parseInt(tokenizer.nextToken())];
        }
    }

    public void dumpBinary(String path) throws IOException {
        FileOutputStream fos = new FileOutputStream(path);
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(fos));
        dos.writeInt(-559038737);
        dos.writeInt(1);
        phonemeTable = this.findPhonemes();
        dos.writeInt(phonemeTable.size());
        Iterator<Object> i = phonemeTable.iterator();
        while (i.hasNext()) {
            String phoneme = (String)i.next();
            dos.writeUTF(phoneme);
        }
        dos.writeInt(this.letterIndex.size());
        i = this.letterIndex.keySet().iterator();
        while (i.hasNext()) {
            String letter = (String)i.next();
            int index = (Integer)this.letterIndex.get(letter);
            dos.writeChar(letter.charAt(0));
            dos.writeInt(index);
        }
        dos.writeInt(this.stateMachine.length);
        for (int i2 = 0; i2 < this.stateMachine.length; ++i2) {
            this.getState(i2).writeBinary(dos);
        }
        dos.close();
    }

    private List findPhonemes() {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < this.stateMachine.length; ++i) {
            if (!(this.stateMachine[i] instanceof FinalState)) continue;
            FinalState fstate = (FinalState)this.stateMachine[i];
            if (fstate.phoneList == null) continue;
            for (int j = 0; j < fstate.phoneList.length; ++j) {
                set.add(fstate.phoneList[j]);
            }
        }
        return new ArrayList(set);
    }

    protected State getState(int i) {
        State state = null;
        if (this.stateMachine[i] instanceof String) {
            state = this.getState((String)this.stateMachine[i]);
            if (this.tokenizeOnLookup) {
                this.stateMachine[i] = state;
            }
        } else {
            state = (State)this.stateMachine[i];
        }
        return state;
    }

    protected State getState(String s) {
        StringTokenizer tokenizer = new StringTokenizer(s, " ");
        return this.getState(tokenizer.nextToken(), tokenizer);
    }

    protected State getState(String type, StringTokenizer tokenizer) {
        if (type.equals(STATE)) {
            int index = Integer.parseInt(tokenizer.nextToken());
            String c = tokenizer.nextToken();
            int qtrue = Integer.parseInt(tokenizer.nextToken());
            int qfalse = Integer.parseInt(tokenizer.nextToken());
            return new DecisionState(index, c.charAt(0), qtrue, qfalse);
        }
        if (type.equals(PHONE)) {
            return new FinalState(tokenizer.nextToken());
        }
        return null;
    }

    protected char[] getFullBuff(String word) {
        int i;
        char[] full_buff = new char[word.length() + 8];
        for (i = 0; i < 3; ++i) {
            full_buff[i] = 48;
        }
        full_buff[3] = 35;
        word.getChars(0, word.length(), full_buff, 4);
        for (i = 0; i < 3; ++i) {
            full_buff[full_buff.length - i - 1] = 48;
        }
        full_buff[full_buff.length - 4] = 35;
        return full_buff;
    }

    public String[] getPhones(String word, String partOfSpeech) {
        ArrayList phoneList = new ArrayList();
        char[] full_buff = this.getFullBuff(word);
        for (int pos = 0; pos < word.length(); ++pos) {
            for (int i = 0; i < 4; ++i) {
                this.fval_buff[i] = full_buff[pos + i];
                this.fval_buff[i + 4] = full_buff[i + pos + 1 + 4];
            }
            char c = word.charAt(pos);
            Integer startIndex = (Integer)this.letterIndex.get(Character.toString(c));
            if (startIndex == null) continue;
            if (!$assertionsDisabled && startIndex == null) {
                throw new AssertionError();
            }
            int stateIndex = startIndex;
            State currentState = this.getState(stateIndex);
            while (!(currentState instanceof FinalState)) {
                stateIndex = ((DecisionState)currentState).getNextState(this.fval_buff);
                currentState = this.getState(stateIndex);
            }
            ((FinalState)currentState).append(phoneList);
        }
        return phoneList.toArray(new String[0]);
    }

    public boolean compare(LetterToSoundImpl other) {
        Iterator i = this.letterIndex.keySet().iterator();
        while (i.hasNext()) {
            Integer otherIndex;
            String key = (String)i.next();
            Integer thisIndex = (Integer)this.letterIndex.get(key);
            if (thisIndex.equals(otherIndex = (Integer)other.letterIndex.get(key))) continue;
            System.out.println("Bad Index for " + key);
            return false;
        }
        for (int i2 = 0; i2 < this.stateMachine.length; ++i2) {
            State otherState;
            State state = this.getState(i2);
            if (state.compare(otherState = other.getState(i2))) continue;
            System.out.println("Bad state " + i2);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        boolean showTimes = false;
        String srcPath = ".";
        String destPath = ".";
        String name = "cmulex_lts";
        try {
            if (args.length > 0) {
                BulkTimer timer = new BulkTimer();
                timer.start();
                for (int i = 0; i < args.length; ++i) {
                    LetterToSoundImpl text;
                    if (args[i].equals("-src")) {
                        srcPath = args[++i];
                        continue;
                    }
                    if (args[i].equals("-dest")) {
                        destPath = args[++i];
                        continue;
                    }
                    if (args[i].equals("-name") && i < args.length - 1) {
                        name = args[++i];
                        continue;
                    }
                    if (args[i].equals("-generate_binary")) {
                        System.out.println("Loading " + name);
                        timer.start("load_text");
                        text = new LetterToSoundImpl(new URL("file:" + srcPath + "/" + name + ".txt"), false);
                        timer.stop("load_text");
                        System.out.println("Dumping " + name);
                        timer.start("dump_binary");
                        text.dumpBinary(destPath + "/" + name + ".bin");
                        timer.stop("dump_binary");
                        continue;
                    }
                    if (args[i].equals("-compare")) {
                        timer.start("load_text");
                        text = new LetterToSoundImpl(new URL("file:./" + name + ".txt"), false);
                        timer.stop("load_text");
                        timer.start("load_binary");
                        LetterToSoundImpl binary = new LetterToSoundImpl(new URL("file:./" + name + ".bin"), true);
                        timer.stop("load_binary");
                        timer.start("compare");
                        if (!text.compare(binary)) {
                            System.out.println("NOT EQUIVALENT");
                        } else {
                            System.out.println("ok");
                        }
                        timer.stop("compare");
                        continue;
                    }
                    if (args[i].equals("-showtimes")) {
                        showTimes = true;
                        continue;
                    }
                    System.out.println("Unknown option " + args[i]);
                }
                timer.stop();
                if (showTimes) {
                    timer.show("LTS loading and dumping");
                }
            } else {
                System.out.println("Options: ");
                System.out.println("    -src path");
                System.out.println("    -dest path");
                System.out.println("    -compare");
                System.out.println("    -generate_binary");
                System.out.println("    -showTimes");
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
    }

    static {
        $assertionsDisabled = !LetterToSoundImpl.class.desiredAssertionStatus();
    }

    static class FinalState
    implements State {
        static final int TYPE = 2;
        String[] phoneList;

        public FinalState(String phones) {
            if (phones.equals("epsilon")) {
                this.phoneList = null;
            } else {
                int i = phones.indexOf(45);
                if (i != -1) {
                    this.phoneList = new String[2];
                    this.phoneList[0] = phones.substring(0, i);
                    this.phoneList[1] = phones.substring(i + 1);
                } else {
                    this.phoneList = new String[1];
                    this.phoneList[0] = phones;
                }
            }
        }

        public FinalState(String[] phones) {
            this.phoneList = phones;
        }

        public void append(ArrayList array) {
            if (this.phoneList == null) {
                return;
            }
            for (int i = 0; i < this.phoneList.length; ++i) {
                array.add(this.phoneList[i]);
            }
        }

        public String toString() {
            if (this.phoneList == null) {
                return "PHONE epsilon";
            }
            if (this.phoneList.length == 1) {
                return "PHONE " + this.phoneList[0];
            }
            return "PHONE " + this.phoneList[0] + "-" + this.phoneList[1];
        }

        public boolean compare(State other) {
            if (other instanceof FinalState) {
                FinalState otherState = (FinalState)other;
                if (this.phoneList == null) {
                    return otherState.phoneList == null;
                }
                for (int i = 0; i < this.phoneList.length; ++i) {
                    if (this.phoneList[i].equals(otherState.phoneList[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public void writeBinary(DataOutputStream dos) throws IOException {
            dos.writeInt(2);
            if (this.phoneList == null) {
                dos.writeInt(0);
            } else {
                dos.writeInt(this.phoneList.length);
                for (int i = 0; i < this.phoneList.length; ++i) {
                    dos.writeInt(phonemeTable.indexOf(this.phoneList[i]));
                }
            }
        }

        public static State loadBinary(DataInputStream dis) throws IOException {
            int phoneListLength = dis.readInt();
            String[] phoneList = phoneListLength == 0 ? null : new String[phoneListLength];
            for (int i = 0; i < phoneListLength; ++i) {
                int index = dis.readInt();
                phoneList[i] = (String)phonemeTable.get(index);
            }
            return new FinalState(phoneList);
        }
    }

    static class DecisionState
    implements State {
        static final int TYPE = 1;
        int index;
        char c;
        int qtrue;
        int qfalse;

        public DecisionState(int index, char c, int qtrue, int qfalse) {
            this.index = index;
            this.c = c;
            this.qtrue = qtrue;
            this.qfalse = qfalse;
        }

        public int getNextState(char[] chars) {
            return chars[this.index] == this.c ? this.qtrue : this.qfalse;
        }

        public String toString() {
            return "STATE " + Integer.toString(this.index) + " " + Character.toString(this.c) + " " + Integer.toString(this.qtrue) + " " + Integer.toString(this.qfalse);
        }

        public void writeBinary(DataOutputStream dos) throws IOException {
            dos.writeInt(1);
            dos.writeInt(this.index);
            dos.writeChar(this.c);
            dos.writeInt(this.qtrue);
            dos.writeInt(this.qfalse);
        }

        public static State loadBinary(DataInputStream dis) throws IOException {
            int index = dis.readInt();
            char c = dis.readChar();
            int qtrue = dis.readInt();
            int qfalse = dis.readInt();
            return new DecisionState(index, c, qtrue, qfalse);
        }

        public boolean compare(State other) {
            if (other instanceof DecisionState) {
                DecisionState otherState = (DecisionState)other;
                return this.index == otherState.index && this.c == otherState.c && this.qtrue == otherState.qtrue && this.qfalse == otherState.qfalse;
            }
            return false;
        }
    }

    static interface State {
        public void writeBinary(DataOutputStream var1) throws IOException;

        public boolean compare(State var1);
    }
}

