/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.util.proxy;

import com.romraider.util.ParamChecker;
import com.romraider.util.proxy.Wrapper;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public final class TimerWrapper
implements Wrapper {
    private static final Logger LOGGER = Logger.getLogger(TimerWrapper.class);
    private final Object delegate;

    public TimerWrapper(Object object) {
        ParamChecker.checkNotNull(object);
        this.delegate = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object object2 = method.invoke(this.delegate, objectArray);
            return object2;
        }
        finally {
            long l2 = System.currentTimeMillis() - l;
            this.log(method, l2);
        }
    }

    private void log(Method method, long l) {
        String string = this.delegate.getClass().getSimpleName();
        String string2 = method.getName();
        LOGGER.error((Object)("[TIMER] - " + string + "." + string2 + ": " + l + "ms"));
    }
}

