/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.maps.Rom;
import com.romraider.maps.Table;
import com.romraider.swing.CategoryTreeNode;
import com.romraider.swing.TableFrame;
import com.romraider.swing.TableTreeNode;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class RomTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -5534315445738460608L;
    private Rom rom = new Rom();

    public RomTreeNode(Rom rom, int n, boolean bl) {
        this.setRom(rom);
        this.refresh(n, bl);
        this.updateFileName();
    }

    public void refresh(int n, boolean bl) {
        this.removeAllChildren();
        Vector<Table> vector = this.rom.getTables();
        for (int i = 0; i < vector.size(); ++i) {
            Table table = vector.get(i);
            this.add(table);
            if (!bl && n < table.getUserLevel()) continue;
            boolean bl2 = false;
            for (int j = 0; j < this.getChildCount(); ++j) {
                if (!this.getChildAt(j).toString().equals(table.getCategory())) continue;
                TableTreeNode tableTreeNode = new TableTreeNode(table);
                this.getChildAt(j).add(tableTreeNode);
                bl2 = true;
                break;
            }
            if (bl2) continue;
            this.add(new CategoryTreeNode(table.getCategory(), table.getRom()));
            TableTreeNode tableTreeNode = new TableTreeNode(table);
            this.getLastChild().add(tableTreeNode);
        }
    }

    public void removeAllChildren() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.getChildAt(i);
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                ((TableTreeNode)enumeration.nextElement()).getFrame().dispose();
            }
        }
        super.removeAllChildren();
    }

    public void updateFileName() {
        this.setUserObject(this.rom);
    }

    public void add(Table table) {
        TableFrame tableFrame = new TableFrame(table);
        table.setFrame(tableFrame);
    }

    public DefaultMutableTreeNode getChildAt(int n) {
        return (DefaultMutableTreeNode)super.getChildAt(n);
    }

    public DefaultMutableTreeNode getLastChild() {
        return (DefaultMutableTreeNode)super.getLastChild();
    }

    public Rom getRom() {
        return this.rom;
    }

    public void setRom(Rom rom) {
        this.rom = rom;
    }
}

