/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.maps;

import com.romraider.Settings;
import com.romraider.maps.DataCell;
import com.romraider.maps.Rom;
import com.romraider.maps.Scale;
import com.romraider.swing.TableFrame;
import com.romraider.util.ColorScaler;
import com.romraider.util.JEPUtil;
import com.romraider.xml.RomAttributeParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Table
extends JPanel
implements Serializable {
    private static final String BLANK = "";
    public static final int ENDIAN_LITTLE = 1;
    public static final int ENDIAN_BIG = 2;
    public static final int TABLE_1D = 1;
    public static final int TABLE_2D = 2;
    public static final int TABLE_3D = 3;
    public static final int TABLE_X_AXIS = 4;
    public static final int TABLE_Y_AXIS = 5;
    public static final int TABLE_SWITCH = 6;
    public static final int COMPARE_OFF = 0;
    public static final int COMPARE_ORIGINAL = 1;
    public static final int COMPARE_TABLE = 2;
    public static final int COMPARE_PERCENT = 0;
    public static final int COMPARE_ABSOLUTE = 1;
    public static final int STORAGE_TYPE_FLOAT = 99;
    protected static final Color UNCHANGED_VALUE_COLOR = new Color(160, 160, 160);
    protected String name;
    protected int type;
    protected String category = "Other";
    protected String description = "";
    protected Vector<Scale> scales = new Vector();
    protected int scaleIndex = 0;
    protected int storageAddress;
    protected int storageType;
    protected int endian;
    protected boolean flip;
    protected DataCell[] data = new DataCell[0];
    protected boolean isStatic = false;
    protected boolean beforeRam = false;
    protected int ramOffset = 0;
    protected BorderLayout borderLayout = new BorderLayout();
    protected GridLayout centerLayout = new GridLayout(1, 1, 0, 0);
    protected JPanel centerPanel = new JPanel(this.centerLayout);
    protected TableFrame frame;
    protected int verticalOverhead = 103;
    protected int horizontalOverhead = 2;
    protected int cellHeight = 18;
    protected int cellWidth = 42;
    protected int minHeight = 100;
    protected int minWidthNoOverlay = 465;
    protected int minWidthOverlay = 700;
    protected Rom container;
    protected int highlightX;
    protected int highlightY;
    protected boolean highlight = false;
    protected Table axisParent;
    protected Color maxColor;
    protected Color minColor;
    protected boolean isAxis = false;
    protected int compareType = 0;
    protected int compareDisplay = 1;
    protected int userLevel = 0;
    protected Settings settings;
    protected boolean locked = false;
    protected String logParam = "";
    protected String liveValue = "";
    protected boolean overlayLog = false;

    public Table(Settings settings) {
        this.setSettings(settings);
        this.setLayout(this.borderLayout);
        this.add((Component)this.centerPanel, "Center");
        this.centerPanel.setVisible(true);
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = 1042884198300385041L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.cursorRight();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){
            private static final long serialVersionUID = -4970441255677214171L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.cursorLeft();
            }
        };
        AbstractAction abstractAction3 = new AbstractAction(){
            private static final long serialVersionUID = -7898502951121825984L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.cursorDown();
            }
        };
        AbstractAction abstractAction4 = new AbstractAction(){
            private static final long serialVersionUID = 6937621541727666631L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.cursorUp();
            }
        };
        AbstractAction abstractAction5 = new AbstractAction(){
            private static final long serialVersionUID = -8308522736529183148L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.frame.getToolBar().incrementCoarse();
            }
        };
        AbstractAction abstractAction6 = new AbstractAction(){
            private static final long serialVersionUID = -7407628920997400915L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.frame.getToolBar().decrementCoarse();
            }
        };
        AbstractAction abstractAction7 = new AbstractAction(){
            private static final long serialVersionUID = 7261463425941761433L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.frame.getToolBar().incrementFine();
            }
        };
        AbstractAction abstractAction8 = new AbstractAction(){
            private static final long serialVersionUID = 8929400237520608035L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.frame.getToolBar().decrementFine();
            }
        };
        AbstractAction abstractAction9 = new AbstractAction(){
            private static final long serialVersionUID = -6310984176739090034L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.getFrame().getToolBar().focusSetValue('0');
            }
        };
        AbstractAction abstractAction10 = new AbstractAction(){
            private static final long serialVersionUID = -6187220355403883499L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.getFrame().getToolBar().focusSetValue('1');
            }
        };
        AbstractAction abstractAction11 = new AbstractAction(){
            private static final long serialVersionUID = -8745505977907325720L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.getFrame().getToolBar().focusSetValue('2');
            }
        };
        AbstractAction abstractAction12 = new AbstractAction(){
            private static final long serialVersionUID = 4694872385823448942L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.getFrame().getToolBar().focusSetValue('3');
            }
        };
        AbstractAction abstractAction13 = new AbstractAction(){
            private static final long serialVersionUID = 4005741329254221678L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.getFrame().getToolBar().focusSetValue('4');
            }
        };
        AbstractAction abstractAction14 = new AbstractAction(){
            private static final long serialVersionUID = -5846094949106279884L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.getFrame().getToolBar().focusSetValue('5');
            }
        };
        AbstractAction abstractAction15 = new AbstractAction(){
            private static final long serialVersionUID = -5338656374925334150L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.getFrame().getToolBar().focusSetValue('6');
            }
        };
        AbstractAction abstractAction16 = new AbstractAction(){
            private static final long serialVersionUID = 1959983381590509303L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.getFrame().getToolBar().focusSetValue('7');
            }
        };
        AbstractAction abstractAction17 = new AbstractAction(){
            private static final long serialVersionUID = 7442763278699460648L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.getFrame().getToolBar().focusSetValue('8');
            }
        };
        AbstractAction abstractAction18 = new AbstractAction(){
            private static final long serialVersionUID = 7475171864584215094L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.getFrame().getToolBar().focusSetValue('9');
            }
        };
        AbstractAction abstractAction19 = new AbstractAction(){
            private static final long serialVersionUID = -4729135055857591830L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.getFrame().getToolBar().focusSetValue('.');
            }
        };
        AbstractAction abstractAction20 = new AbstractAction(){
            private static final long serialVersionUID = -6978981449261938672L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.copySelection();
            }
        };
        AbstractAction abstractAction21 = new AbstractAction(){
            private static final long serialVersionUID = 2026817603236490899L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.paste();
            }
        };
        AbstractAction abstractAction22 = new AbstractAction(){
            private static final long serialVersionUID = -2350912575392447149L;

            public void actionPerformed(ActionEvent actionEvent) {
                Table.this.getFrame().getToolBar().multiply();
            }
        };
        InputMap inputMap = this.getInputMap(2);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(39, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(37, 0);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(38, 0);
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(40, 0);
        KeyStroke keyStroke5 = KeyStroke.getKeyStroke('-');
        KeyStroke keyStroke6 = KeyStroke.getKeyStroke('+');
        KeyStroke keyStroke7 = KeyStroke.getKeyStroke("control DOWN");
        KeyStroke keyStroke8 = KeyStroke.getKeyStroke("control UP");
        KeyStroke keyStroke9 = KeyStroke.getKeyStroke(45, 128);
        KeyStroke keyStroke10 = KeyStroke.getKeyStroke(521, 128);
        KeyStroke keyStroke11 = KeyStroke.getKeyStroke("control shift DOWN");
        KeyStroke keyStroke12 = KeyStroke.getKeyStroke("control shift UP");
        KeyStroke keyStroke13 = KeyStroke.getKeyStroke('0');
        KeyStroke keyStroke14 = KeyStroke.getKeyStroke('1');
        KeyStroke keyStroke15 = KeyStroke.getKeyStroke('2');
        KeyStroke keyStroke16 = KeyStroke.getKeyStroke('3');
        KeyStroke keyStroke17 = KeyStroke.getKeyStroke('4');
        KeyStroke keyStroke18 = KeyStroke.getKeyStroke('5');
        KeyStroke keyStroke19 = KeyStroke.getKeyStroke('6');
        KeyStroke keyStroke20 = KeyStroke.getKeyStroke('7');
        KeyStroke keyStroke21 = KeyStroke.getKeyStroke('8');
        KeyStroke keyStroke22 = KeyStroke.getKeyStroke('9');
        KeyStroke keyStroke23 = KeyStroke.getKeyStroke('*');
        KeyStroke keyStroke24 = KeyStroke.getKeyStroke(10, 128);
        KeyStroke keyStroke25 = KeyStroke.getKeyStroke('.');
        KeyStroke keyStroke26 = KeyStroke.getKeyStroke("control C");
        KeyStroke keyStroke27 = KeyStroke.getKeyStroke("control V");
        inputMap.put(keyStroke, "right");
        inputMap.put(keyStroke2, "left");
        inputMap.put(keyStroke3, "up");
        inputMap.put(keyStroke4, "down");
        inputMap.put(keyStroke6, "incCoarseAction");
        inputMap.put(keyStroke5, "decCoarseAction");
        inputMap.put(keyStroke8, "incCoarseAction");
        inputMap.put(keyStroke7, "decCoarseAction");
        inputMap.put(keyStroke10, "incFineAction");
        inputMap.put(keyStroke9, "decFineAction");
        inputMap.put(keyStroke12, "incFineAction");
        inputMap.put(keyStroke11, "decFineAction");
        inputMap.put(keyStroke13, "num0Action");
        inputMap.put(keyStroke14, "num1Action");
        inputMap.put(keyStroke15, "num2Action");
        inputMap.put(keyStroke16, "num3Action");
        inputMap.put(keyStroke17, "num4Action");
        inputMap.put(keyStroke18, "num5Action");
        inputMap.put(keyStroke19, "num6Action");
        inputMap.put(keyStroke20, "num7Action");
        inputMap.put(keyStroke21, "num8Action");
        inputMap.put(keyStroke22, "num9Action");
        inputMap.put(keyStroke25, "numPointAction");
        inputMap.put(keyStroke26, "copyAction");
        inputMap.put(keyStroke27, "pasteAction");
        inputMap.put(keyStroke23, "mulAction");
        inputMap.put(keyStroke24, "mulAction");
        this.getActionMap().put(inputMap.get(keyStroke), abstractAction);
        this.getActionMap().put(inputMap.get(keyStroke2), abstractAction2);
        this.getActionMap().put(inputMap.get(keyStroke3), abstractAction4);
        this.getActionMap().put(inputMap.get(keyStroke4), abstractAction3);
        this.getActionMap().put(inputMap.get(keyStroke6), abstractAction5);
        this.getActionMap().put(inputMap.get(keyStroke5), abstractAction6);
        this.getActionMap().put(inputMap.get(keyStroke8), abstractAction5);
        this.getActionMap().put(inputMap.get(keyStroke7), abstractAction6);
        this.getActionMap().put(inputMap.get(keyStroke10), abstractAction7);
        this.getActionMap().put(inputMap.get(keyStroke9), abstractAction8);
        this.getActionMap().put(inputMap.get(keyStroke12), abstractAction7);
        this.getActionMap().put(inputMap.get(keyStroke11), abstractAction8);
        this.getActionMap().put(inputMap.get(keyStroke13), abstractAction9);
        this.getActionMap().put(inputMap.get(keyStroke14), abstractAction10);
        this.getActionMap().put(inputMap.get(keyStroke15), abstractAction11);
        this.getActionMap().put(inputMap.get(keyStroke16), abstractAction12);
        this.getActionMap().put(inputMap.get(keyStroke17), abstractAction13);
        this.getActionMap().put(inputMap.get(keyStroke18), abstractAction14);
        this.getActionMap().put(inputMap.get(keyStroke19), abstractAction15);
        this.getActionMap().put(inputMap.get(keyStroke20), abstractAction16);
        this.getActionMap().put(inputMap.get(keyStroke21), abstractAction17);
        this.getActionMap().put(inputMap.get(keyStroke22), abstractAction18);
        this.getActionMap().put(inputMap.get(keyStroke25), abstractAction19);
        this.getActionMap().put(inputMap.get(keyStroke23), abstractAction22);
        this.getActionMap().put(inputMap.get(keyStroke24), abstractAction22);
        this.getActionMap().put(inputMap.get(keyStroke26), abstractAction20);
        this.getActionMap().put(inputMap.get(keyStroke27), abstractAction21);
        this.setInputMap(0, inputMap);
    }

    public DataCell[] getData() {
        return this.data;
    }

    public void setData(DataCell[] dataCellArray) {
        this.data = dataCellArray;
    }

    public void populateTable(byte[] byArray) throws ArrayIndexOutOfBoundsException {
        if (this.scales.isEmpty()) {
            this.scales.add(new Scale());
        }
        boolean bl = this.locked;
        this.locked = false;
        if (!this.isStatic) {
            if (!this.beforeRam) {
                this.ramOffset = this.container.getRomID().getRamOffset();
            }
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] != null) continue;
                this.data[i] = new DataCell(this.scales.get(this.scaleIndex), this.settings.getCellSize());
                this.data[i].setTable(this);
                if (this.storageType == 99) {
                    byte[] byArray2 = new byte[]{byArray[this.storageAddress + i * 4 - this.ramOffset], byArray[this.storageAddress + i * 4 - this.ramOffset + 1], byArray[this.storageAddress + i * 4 - this.ramOffset + 2], byArray[this.storageAddress + i * 4 - this.ramOffset + 3]};
                    this.data[i].setBinValue(RomAttributeParser.byteToFloat(byArray2, this.endian));
                } else {
                    this.data[i].setBinValue(RomAttributeParser.parseByteValue(byArray, this.endian, this.storageAddress + i * this.storageType - this.ramOffset, this.storageType));
                }
                this.data[i].setPreferredSize(new Dimension(this.cellWidth, this.cellHeight));
                this.centerPanel.add(this.data[i]);
                this.data[i].setYCoord(i);
                this.data[i].setOriginalValue(this.data[i].getBinValue());
                if (!bl) continue;
                this.data[i].setForeground(Color.GRAY);
            }
        }
        this.locked = bl;
    }

    public int getType() {
        return this.type;
    }

    public DataCell getDataCell(int n) {
        return this.data[n];
    }

    public void setType(int n) {
        this.type = n;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Scale getScale() {
        return this.scales.get(this.scaleIndex);
    }

    public Vector<Scale> getScales() {
        return this.scales;
    }

    public Scale getScaleByName(String string) throws Exception {
        for (Scale scale : this.scales) {
            if (!scale.getName().equalsIgnoreCase(string)) continue;
            return scale;
        }
        throw new Exception();
    }

    public void setScale(Scale scale) {
        for (int i = 0; i < this.scales.size(); ++i) {
            if (!this.scales.get(i).getName().equalsIgnoreCase(scale.getName())) continue;
            this.scales.remove(i);
            break;
        }
        this.scales.add(scale);
    }

    public int getStorageAddress() {
        return this.storageAddress;
    }

    public void setStorageAddress(int n) {
        this.storageAddress = n;
    }

    public int getStorageType() {
        return this.storageType;
    }

    public void setStorageType(int n) {
        this.storageType = n;
    }

    public int getEndian() {
        return this.endian;
    }

    public void setEndian(int n) {
        this.endian = n;
    }

    public void setDataSize(int n) {
        this.data = new DataCell[n];
    }

    public int getDataSize() {
        return this.data.length;
    }

    public boolean getFlip() {
        return this.flip;
    }

    public void setFlip(boolean bl) {
        this.flip = bl;
    }

    public void setLogParam(String string) {
        this.logParam = string;
    }

    public String getLogParam() {
        return this.logParam;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setIsStatic(boolean bl) {
        this.isStatic = bl;
    }

    public void addStaticDataCell(DataCell dataCell) {
        if (this.isStatic) {
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] != null) continue;
                this.data[i] = dataCell;
                break;
            }
        }
    }

    public void colorize() {
        double d;
        if (this.compareType == 0) {
            if (!this.isStatic && !this.isAxis) {
                int n;
                double d2 = Double.MIN_VALUE;
                double d3 = Double.MAX_VALUE;
                if (this.getScale().getMax() != 0.0 || this.getScale().getMin() != 0.0) {
                    d2 = this.getScale().getMax();
                    d3 = this.getScale().getMin();
                } else {
                    for (n = 0; n < this.getDataSize(); ++n) {
                        d = this.data[n].getValue();
                        if (d > d2) {
                            d2 = d;
                        }
                        if (!(d < d3)) continue;
                        d3 = d;
                    }
                }
                for (n = 0; n < this.getDataSize(); ++n) {
                    d = this.data[n].getValue();
                    if (d > d2 || d < d3) {
                        this.data[n].setColor(this.getSettings().getWarningColor());
                        continue;
                    }
                    double d4 = d2 - d3 == 0.0 ? 0.5 : (d - d3) / (d2 - d3);
                    this.data[n].setColor(ColorScaler.getScaledColor(d4, this.getSettings()));
                }
            } else {
                for (int i = 0; i < this.getDataSize(); ++i) {
                    this.data[i].setColor(this.getSettings().getAxisColor());
                    this.data[i].setOpaque(true);
                    this.data[i].setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
                    this.data[i].setHorizontalAlignment(0);
                }
            }
        } else if (!this.isStatic) {
            int n;
            double d5 = Double.MIN_VALUE;
            for (n = 0; n < this.getDataSize(); ++n) {
                if (!(Math.abs(this.data[n].getBinValue() - this.data[n].getOriginalValue()) > d5)) continue;
                d5 = Math.abs(this.data[n].getBinValue() - this.data[n].getOriginalValue());
            }
            for (n = 0; n < this.getDataSize(); ++n) {
                double d6 = Math.abs(this.data[n].getBinValue() - this.data[n].getOriginalValue());
                d = d5 == 0.0 ? 0.0 : d6 / d5;
                if (d == 0.0) {
                    this.data[n].setColor(UNCHANGED_VALUE_COLOR);
                } else {
                    this.data[n].setColor(ColorScaler.getScaledColor(d, this.getSettings()));
                }
                if (this.data[n].getBinValue() > this.data[n].getOriginalValue()) {
                    this.data[n].setBorder(BorderFactory.createLineBorder(this.getSettings().getIncreaseBorder()));
                    continue;
                }
                if (this.data[n].getBinValue() < this.data[n].getOriginalValue()) {
                    this.data[n].setBorder(BorderFactory.createLineBorder(this.getSettings().getDecreaseBorder()));
                    continue;
                }
                this.data[n].setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            }
        }
        if (!this.isStatic) {
            for (int i = 0; i < this.getDataSize(); ++i) {
                if (this.data[i].getBinValue() > this.data[i].getOriginalValue()) {
                    this.data[i].setBorder(BorderFactory.createLineBorder(this.getSettings().getIncreaseBorder()));
                    continue;
                }
                if (this.data[i].getBinValue() < this.data[i].getOriginalValue()) {
                    this.data[i].setBorder(BorderFactory.createLineBorder(this.getSettings().getDecreaseBorder()));
                    continue;
                }
                this.data[i].setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            }
        }
    }

    public void setFrame(TableFrame tableFrame) {
        this.frame = tableFrame;
        tableFrame.pack();
    }

    public Dimension getFrameSize() {
        int n;
        int n2 = this.verticalOverhead + this.cellHeight;
        int n3 = this.horizontalOverhead + this.data.length * this.cellWidth;
        if (n2 < this.minHeight) {
            n2 = this.minHeight;
        }
        int n4 = n = this.isLiveDataSupported() ? this.minWidthOverlay : this.minWidthNoOverlay;
        if (n3 < n) {
            n3 = n;
        }
        return new Dimension(n3, n2);
    }

    public TableFrame getFrame() {
        return this.frame;
    }

    public void increment(double d) {
        if (!this.isStatic && !this.locked && this.userLevel <= this.settings.getUserLevel()) {
            for (DataCell dataCell : this.data) {
                if (!dataCell.isSelected().booleanValue()) continue;
                dataCell.increment(d);
            }
            this.colorize();
        } else if (this.userLevel > this.settings.getUserLevel()) {
            JOptionPane.showMessageDialog(this, "This table can only be modified by users with a userlevel of \n" + this.userLevel + " or greater. Click View->User Level to change your userlevel.", "Table cannot be modified", 1);
        }
    }

    public void multiply(double d) {
        if (!this.isStatic && !this.locked && this.userLevel <= this.settings.getUserLevel()) {
            for (DataCell dataCell : this.data) {
                if (!dataCell.isSelected().booleanValue()) continue;
                dataCell.multiply(d);
            }
        } else if (this.userLevel > this.settings.getUserLevel()) {
            JOptionPane.showMessageDialog(this, "This table can only be modified by users with a userlevel of \n" + this.userLevel + " or greater. Click View->User Level to change your userlevel.", "Table cannot be modified", 1);
        }
        this.colorize();
    }

    public void setRealValue(String string) {
        if (!this.isStatic && !this.locked && this.userLevel <= this.settings.getUserLevel()) {
            for (DataCell dataCell : this.data) {
                if (!dataCell.isSelected().booleanValue()) continue;
                dataCell.setRealValue(string);
            }
        } else if (this.userLevel > this.settings.getUserLevel()) {
            JOptionPane.showMessageDialog(this, "This table can only be modified by users with a userlevel of \n" + this.userLevel + " or greater. Click View->User Level to change your userlevel.", "Table cannot be modified", 1);
        }
        this.colorize();
    }

    public Rom getRom() {
        return this.container;
    }

    public void setRom(Rom rom) {
        this.container = rom;
    }

    public void clearSelection() {
        for (DataCell dataCell : this.data) {
            dataCell.setSelected(false);
        }
    }

    public void startHighlight(int n, int n2) {
        this.highlightY = n2;
        this.highlightX = n;
        this.highlight = true;
        this.highlight(n, n2);
    }

    public void highlight(int n, int n2) {
        if (this.highlight) {
            for (int i = 0; i < this.data.length; ++i) {
                if (i >= this.highlightY && i <= n2 || i <= this.highlightY && i >= n2) {
                    this.data[i].setHighlighted(true);
                    continue;
                }
                this.data[i].setHighlighted(false);
            }
        }
    }

    public void stopHighlight() {
        this.highlight = false;
        for (DataCell dataCell : this.data) {
            if (!dataCell.isHighlighted()) continue;
            dataCell.setSelected(true);
            dataCell.setHighlighted(false);
        }
    }

    public abstract void cursorUp();

    public abstract void cursorDown();

    public abstract void cursorLeft();

    public abstract void cursorRight();

    public Table getAxisParent() {
        return this.axisParent;
    }

    public void setAxisParent(Table table) {
        this.axisParent = table;
    }

    public void setRevertPoint() {
        if (!this.isStatic) {
            for (DataCell dataCell : this.data) {
                dataCell.setOriginalValue(dataCell.getBinValue());
            }
        }
        this.colorize();
    }

    public void undoAll() {
        this.clearLiveDataTrace();
        if (!this.isStatic) {
            for (DataCell dataCell : this.data) {
                dataCell.setBinValue(dataCell.getOriginalValue());
            }
        }
        this.colorize();
    }

    public void undoSelected() {
        this.clearLiveDataTrace();
        if (!this.isStatic) {
            for (DataCell dataCell : this.data) {
                if (!dataCell.isSelected().booleanValue()) continue;
                dataCell.setBinValue(dataCell.getOriginalValue());
            }
        }
        this.colorize();
    }

    public byte[] saveFile(byte[] byArray) {
        if (!this.isStatic && this.userLevel <= this.getSettings().getUserLevel() && (this.userLevel < 5 || this.getSettings().isSaveDebugTables())) {
            for (int i = 0; i < this.data.length; ++i) {
                int n;
                byte[] byArray2;
                if (this.storageType != 99) {
                    byArray2 = RomAttributeParser.parseIntegerValue((int)this.data[i].getBinValue(), this.endian, this.storageType);
                    for (n = 0; n < this.storageType; ++n) {
                        byArray[i * this.storageType + n + this.storageAddress - this.ramOffset] = byArray2[n];
                    }
                    continue;
                }
                byArray2 = RomAttributeParser.floatToByte((float)this.data[i].getBinValue(), this.endian);
                for (n = 0; n < 4; ++n) {
                    byArray[i * 4 + n + this.storageAddress - this.ramOffset] = byArray2[n];
                }
            }
        }
        return byArray;
    }

    public boolean isBeforeRam() {
        return this.beforeRam;
    }

    public void setBeforeRam(boolean bl) {
        this.beforeRam = bl;
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        super.addKeyListener(keyListener);
        for (DataCell dataCell : this.data) {
            for (int i = 0; i < this.storageType; ++i) {
                dataCell.addKeyListener(keyListener);
            }
        }
    }

    public void selectCellAt(int n) {
        if (this.type == 4 || this.type == 5) {
            this.axisParent.clearSelection();
        } else {
            this.clearSelection();
        }
        this.data[n].setSelected(true);
        this.highlightY = n;
    }

    public void copySelection() {
        int n;
        String string = System.getProperty("line.separator");
        String string2 = "[Selection1D]" + string;
        boolean bl = false;
        int[] nArray = new int[2];
        nArray[0] = this.getDataSize();
        for (n = 0; n < this.getDataSize(); ++n) {
            if (!this.data[n].isSelected().booleanValue()) continue;
            if (n < nArray[0]) {
                nArray[0] = n;
                bl = true;
            }
            if (n <= nArray[1]) continue;
            nArray[1] = n;
            bl = true;
        }
        for (n = nArray[0]; n <= nArray[1]; ++n) {
            string2 = this.data[n].isSelected() != false ? string2 + this.data[n].getText() : string2 + "x";
            if (n >= nArray[1]) continue;
            string2 = string2 + "\t";
        }
        if (bl) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string2), null);
        }
    }

    public StringBuffer getTableAsString() {
        StringBuffer stringBuffer = new StringBuffer(BLANK);
        for (int i = 0; i < this.getDataSize(); ++i) {
            stringBuffer.append(this.data[i].getText());
            if (i >= this.getDataSize() - 1) continue;
            stringBuffer.append("\t");
        }
        return stringBuffer;
    }

    public void copyTable() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("[Table1D]" + string);
        for (int i = 0; i < this.getDataSize(); ++i) {
            stringBuffer.append(this.data[i].getText());
            if (i >= this.getDataSize() - 1) continue;
            stringBuffer.append("\t");
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(String.valueOf(stringBuffer)), null);
    }

    public String getCellAsString(int n) {
        return this.data[n].getText();
    }

    public void pasteValues(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Double.parseDouble(stringArray[i]);
                this.data[i].setRealValue(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void paste() {
        String string;
        StringTokenizer stringTokenizer = new StringTokenizer(BLANK);
        try {
            string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
            stringTokenizer = new StringTokenizer(string);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        string = stringTokenizer.nextToken();
        if ("[Table1D]".equalsIgnoreCase(string)) {
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    if (!this.data[n].getText().equalsIgnoreCase(string2)) {
                        this.data[n].setRealValue(string2);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                ++n;
            }
        } else if ("[Selection1D]".equalsIgnoreCase(string) && this.data[this.highlightY].isSelected().booleanValue()) {
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    this.data[this.highlightY + n].setRealValue(stringTokenizer.nextToken());
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                ++n;
            }
        }
        this.colorize();
    }

    public void pasteCompare() {
        String string;
        StringTokenizer stringTokenizer = new StringTokenizer(BLANK);
        try {
            string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
            stringTokenizer = new StringTokenizer(string);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        string = stringTokenizer.nextToken();
        if ("[Table1D]".equalsIgnoreCase(string)) {
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    String string2 = stringTokenizer.nextToken();
                    this.data[n].setCompareRealValue(string2);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                ++n;
            }
        }
    }

    public void applyColorSettings(Settings settings) {
        this.setSettings(settings);
        for (int i = 0; i < this.getDataSize(); ++i) {
            this.setMaxColor(settings.getMaxColor());
            this.setMinColor(settings.getMinColor());
            this.data[i].setHighlightColor(settings.getHighlightColor());
            this.data[i].setIncreaseBorder(settings.getIncreaseBorder());
            this.data[i].setDecreaseBorder(settings.getDecreaseBorder());
            this.data[i].setFont(settings.getTableFont());
            this.data[i].repaint();
        }
        this.cellHeight = (int)settings.getCellSize().getHeight();
        this.cellWidth = (int)settings.getCellSize().getWidth();
        this.colorize();
        this.validateScaling();
    }

    public void resize() {
        this.frame.pack();
    }

    public Color getMaxColor() {
        return this.maxColor;
    }

    public void setMaxColor(Color color) {
        this.maxColor = color;
    }

    public Color getMinColor() {
        return this.minColor;
    }

    public void setMinColor(Color color) {
        this.minColor = color;
    }

    public abstract void setAxisColor(Color var1);

    public void validateScaling() {
        if (this.type != 6 && !this.isStatic) {
            if (this.scales.isEmpty()) {
                this.scales.add(new Scale());
            }
            double d = 5.0;
            double d2 = JEPUtil.evaluate(this.scales.get(this.scaleIndex).getExpression(), d);
            double d3 = JEPUtil.evaluate(this.scales.get(this.scaleIndex).getByteExpression(), d2);
            if (Math.abs(d3 - d) > 0.001) {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new GridLayout(4, 1));
                jPanel.add(new JLabel("The real value and byte value conversion expressions for table " + this.name + " are invalid."));
                jPanel.add(new JLabel("To real value: " + this.scales.get(this.scaleIndex).getExpression()));
                jPanel.add(new JLabel("To byte: " + this.scales.get(this.scaleIndex).getByteExpression()));
                JCheckBox jCheckBox = new JCheckBox("Always display this message", true);
                jCheckBox.setHorizontalAlignment(4);
                jPanel.add(jCheckBox);
                jCheckBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Table.this.getSettings().setCalcConflictWarning(((JCheckBox)actionEvent.getSource()).isSelected());
                    }
                });
                JOptionPane.showMessageDialog(this.container.getContainer(), jPanel, "Warning", 0);
            }
        }
    }

    public void compare(int n) {
        this.clearLiveDataTrace();
        this.compareType = n;
        for (int i = 0; i < this.getDataSize(); ++i) {
            if (n == 1) {
                this.data[i].setCompareValue(this.data[i].getOriginalValue());
            }
            this.data[i].setCompareType(n);
            this.data[i].setCompareDisplay(this.compareDisplay);
            this.data[i].updateDisplayValue();
        }
        this.colorize();
    }

    public void setCompareDisplay(int n) {
        this.compareDisplay = n;
        this.compare(this.compareType);
        this.colorize();
    }

    public int getUserLevel() {
        return this.userLevel;
    }

    public void setUserLevel(int n) {
        this.userLevel = n;
        if (n > 5) {
            n = 5;
        } else if (n < 1) {
            n = 1;
        }
    }

    public int getScaleIndex() {
        return this.scaleIndex;
    }

    public void setScaleIndex(int n) {
        this.scaleIndex = n;
        this.refreshValues();
    }

    public void setScaleByName(String string) {
        for (int i = 0; i < this.scales.size(); ++i) {
            if (!this.scales.get(i).getName().equalsIgnoreCase(string)) continue;
            this.setScaleIndex(i);
        }
    }

    public void refreshValues() {
        if (!this.isStatic) {
            for (int i = 0; i < this.getDataSize(); ++i) {
                this.data[i].refreshValue();
            }
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    public void setOverlayLog(boolean bl) {
        this.overlayLog = bl;
        if (bl) {
            this.clearLiveDataTrace();
        }
    }

    public void setLiveValue(String string) {
        this.liveValue = string;
    }

    public double getLiveValue() {
        try {
            return Double.parseDouble(this.liveValue);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public abstract boolean isLiveDataSupported();

    protected void highlightLiveData() {
    }

    public void clearLiveDataTrace() {
        this.liveValue = BLANK;
    }

    public double getMin() {
        if (this.getScale().getMin() == 0.0 && this.getScale().getMax() == 0.0) {
            double d = Double.MAX_VALUE;
            for (int i = 0; i < this.getDataSize(); ++i) {
                double d2 = this.data[i].getValue();
                if (!(d2 < d)) continue;
                d = d2;
            }
            return d;
        }
        return this.getScale().getMin();
    }

    public double getMax() {
        if (this.getScale().getMin() == 0.0 && this.getScale().getMax() == 0.0) {
            double d = Double.MIN_VALUE;
            for (int i = 0; i < this.getDataSize(); ++i) {
                double d2 = this.data[i].getValue();
                if (!(d2 > d)) continue;
                d = d2;
            }
            return d;
        }
        return this.getScale().getMax();
    }
}

