/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.tab.maf;

import com.romraider.ECUEditor;
import com.romraider.logger.ecu.definition.EcuParameter;
import com.romraider.logger.ecu.definition.EcuSwitch;
import com.romraider.logger.ecu.definition.ExternalData;
import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.logger.ecu.ui.DataRegistrationBroker;
import com.romraider.logger.ecu.ui.tab.LoggerChartPanel;
import com.romraider.logger.ecu.ui.tab.TableFinder;
import com.romraider.maps.DataCell;
import com.romraider.maps.Rom;
import com.romraider.maps.Table;
import com.romraider.maps.Table2D;
import com.romraider.util.ParamChecker;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MafControlPanel
extends JPanel {
    private static final long serialVersionUID = 5787020251107365950L;
    private static final Logger LOGGER = Logger.getLogger(MafControlPanel.class);
    private static final String COOLANT_TEMP = "P2";
    private static final String AF_CORRECTION_1 = "P3";
    private static final String AF_LEARNING_1 = "P4";
    private static final String ENGINE_SPEED = "P8";
    private static final String INTAKE_AIR_TEMP = "P11";
    private static final String MASS_AIR_FLOW = "P12";
    private static final String MASS_AIR_FLOW_V = "P18";
    private static final String AFR = "P58";
    private static final String CL_OL_16 = "E3";
    private static final String CL_OL_32 = "E33";
    private static final String TIP_IN_THROTTLE_16 = "E23";
    private static final String TIP_IN_THROTTLE_32 = "E54";
    private final JToggleButton recordDataButton = new JToggleButton("Record Data");
    private final JTextField mafvMin = new JTextField("1.20", 3);
    private final JTextField mafvMax = new JTextField("2.60", 3);
    private final JTextField afrMin = new JTextField("14.0", 3);
    private final JTextField afrMax = new JTextField("16.0", 3);
    private final JTextField rpmMin = new JTextField("0", 3);
    private final JTextField rpmMax = new JTextField("4500", 3);
    private final JTextField mafMin = new JTextField("0", 3);
    private final JTextField mafMax = new JTextField("100", 3);
    private final JTextField iatMax = new JTextField("35", 3);
    private final JTextField coolantMin = new JTextField("70", 3);
    private final JTextField mafvChangeMax = new JTextField("0.2", 3);
    private final DataRegistrationBroker broker;
    private final LoggerChartPanel chartPanel;
    private final ECUEditor ecuEditor;
    private final Component parent;
    private List<ExternalData> externals;
    private List<EcuParameter> params;
    private List<EcuSwitch> switches;

    public MafControlPanel(Component component, DataRegistrationBroker dataRegistrationBroker, ECUEditor eCUEditor, LoggerChartPanel loggerChartPanel) {
        ParamChecker.checkNotNull(component, dataRegistrationBroker, loggerChartPanel);
        this.parent = component;
        this.broker = dataRegistrationBroker;
        this.chartPanel = loggerChartPanel;
        this.ecuEditor = eCUEditor;
        this.addControls();
    }

    public boolean isRecordData() {
        return this.recordDataButton.isSelected();
    }

    public boolean isValidClOl(double d) {
        return d == 8.0;
    }

    public boolean isValidAfr(double d) {
        return this.checkInRange("AFR", this.afrMin, this.afrMax, d);
    }

    public boolean isValidRpm(double d) {
        return this.checkInRange("RPM", this.rpmMin, this.rpmMax, d);
    }

    public boolean isValidMaf(double d) {
        return this.checkInRange("MAF", this.mafMin, this.mafMax, d);
    }

    public boolean isValidMafv(double d) {
        return this.checkInRange("MAFv", this.mafvMin, this.mafvMax, d);
    }

    public boolean isValidCoolantTemp(double d) {
        return this.checkGreaterThan("Coolant Temp.", this.coolantMin, d);
    }

    public boolean isValidIntakeAirTemp(double d) {
        return this.checkLessThan("Intake Air Temp.", this.iatMax, d);
    }

    public boolean isValidMafvChange(double d) {
        return this.checkLessThan("dMAFv/dt", this.mafvChangeMax, d);
    }

    public boolean isValidTipInThrottle(double d) {
        return d == 0.0;
    }

    private boolean checkInRange(String string, JTextField jTextField, JTextField jTextField2, double d) {
        if (this.isValidRange(jTextField, jTextField2)) {
            return this.inRange(d, jTextField, jTextField2);
        }
        JOptionPane.showMessageDialog(this.parent, "Invalid " + string + " range specified.", "Error", 0);
        this.recordDataButton.setSelected(false);
        return false;
    }

    private boolean checkGreaterThan(String string, JTextField jTextField, double d) {
        if (this.isNumber(jTextField)) {
            return d >= this.parseDouble(jTextField);
        }
        JOptionPane.showMessageDialog(this.parent, "Invalid " + string + " specified.", "Error", 0);
        this.recordDataButton.setSelected(false);
        return false;
    }

    private boolean checkLessThan(String string, JTextField jTextField, double d) {
        if (this.isNumber(jTextField)) {
            return d <= this.parseDouble(jTextField);
        }
        JOptionPane.showMessageDialog(this.parent, "Invalid " + string + " specified.", "Error", 0);
        this.recordDataButton.setSelected(false);
        return false;
    }

    private void addControls() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.add(jPanel, gridBagLayout, this.buildFilterPanel(), 0, 0, 1, 2);
        this.add(jPanel, gridBagLayout, this.buildInterpolatePanel(), 0, 1, 1, 2);
        this.add(jPanel, gridBagLayout, this.buildUpdateMafPanel(), 0, 2, 1, 2);
        this.add(jPanel, gridBagLayout, this.buildResetPanel(), 0, 3, 1, 2);
        this.add(jPanel);
    }

    private void add(JPanel jPanel, GridBagLayout gridBagLayout, JComponent jComponent, int n, int n2, int n3, int n4) {
        GridBagConstraints gridBagConstraints = this.buildBaseConstraints();
        this.updateConstraints(gridBagConstraints, n, n2, n3, 1, 1, 1, n4);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
    }

    private JPanel buildResetPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder("Reset"));
        jPanel.add(this.buildResetButton());
        return jPanel;
    }

    private JPanel buildUpdateMafPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder("Update MAF"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.addMinMaxFilter(jPanel, gridBagLayout, "MAFv Range", this.mafvMin, this.mafvMax, 0);
        this.addComponent(jPanel, gridBagLayout, this.buildUpdateMafButton(), 3);
        return jPanel;
    }

    private JPanel buildInterpolatePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder("Interpolate"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        JComboBox jComboBox = this.buildPolyOrderComboBox();
        this.addLabeledComponent(jPanel, gridBagLayout, "Poly. order", jComboBox, 0);
        this.addComponent(jPanel, gridBagLayout, this.buildInterpolateButton(jComboBox), 2);
        return jPanel;
    }

    private void addLabeledComponent(JPanel jPanel, GridBagLayout gridBagLayout, String string, JComponent jComponent, int n) {
        this.add(jPanel, gridBagLayout, new JLabel(string), 0, n, 3, 2);
        this.add(jPanel, gridBagLayout, jComponent, 0, n + 1, 3, 0);
    }

    private JPanel buildFilterPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder("Filter Data"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.addMinMaxFilter(jPanel, gridBagLayout, "AFR Range", this.afrMin, this.afrMax, 0);
        this.addMinMaxFilter(jPanel, gridBagLayout, "RPM Range", this.rpmMin, this.rpmMax, 3);
        this.addMinMaxFilter(jPanel, gridBagLayout, "MAF Range (g/s)", this.mafMin, this.mafMax, 6);
        this.addLabeledComponent(jPanel, gridBagLayout, "Min. Coolant Temp.", this.coolantMin, 9);
        this.addLabeledComponent(jPanel, gridBagLayout, "Max. Intake Temp.", this.iatMax, 12);
        this.addLabeledComponent(jPanel, gridBagLayout, "Max. dMAFv/dt (V/s)", this.mafvChangeMax, 15);
        this.addComponent(jPanel, gridBagLayout, this.buildRecordDataButton(), 18);
        return jPanel;
    }

    private JToggleButton buildRecordDataButton() {
        this.recordDataButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MafControlPanel.this.recordDataButton.isSelected()) {
                    MafControlPanel.this.registerData(new String[]{MafControlPanel.COOLANT_TEMP, MafControlPanel.AF_CORRECTION_1, MafControlPanel.AF_LEARNING_1, MafControlPanel.ENGINE_SPEED, MafControlPanel.INTAKE_AIR_TEMP, MafControlPanel.MASS_AIR_FLOW, MafControlPanel.MASS_AIR_FLOW_V, MafControlPanel.AFR, MafControlPanel.CL_OL_16, MafControlPanel.CL_OL_32, MafControlPanel.TIP_IN_THROTTLE_16, MafControlPanel.TIP_IN_THROTTLE_32});
                } else {
                    MafControlPanel.this.deregisterData(new String[]{MafControlPanel.COOLANT_TEMP, MafControlPanel.AF_CORRECTION_1, MafControlPanel.AF_LEARNING_1, MafControlPanel.ENGINE_SPEED, MafControlPanel.INTAKE_AIR_TEMP, MafControlPanel.MASS_AIR_FLOW, MafControlPanel.MASS_AIR_FLOW_V, MafControlPanel.AFR, MafControlPanel.CL_OL_16, MafControlPanel.CL_OL_32, MafControlPanel.TIP_IN_THROTTLE_16, MafControlPanel.TIP_IN_THROTTLE_32});
                }
            }
        });
        return this.recordDataButton;
    }

    private void registerData(String ... stringArray) {
        for (String string : stringArray) {
            LoggerData loggerData = this.findData(string);
            if (loggerData == null) continue;
            this.broker.registerLoggerDataForLogging(loggerData);
        }
    }

    private void deregisterData(String ... stringArray) {
        for (String string : stringArray) {
            LoggerData loggerData = this.findData(string);
            if (loggerData == null) continue;
            this.broker.deregisterLoggerDataFromLogging(loggerData);
        }
    }

    private LoggerData findData(String string) {
        for (EcuParameter loggerData : this.params) {
            if (!string.equals(loggerData.getId())) continue;
            return loggerData;
        }
        for (EcuSwitch ecuSwitch : this.switches) {
            if (!string.equals(ecuSwitch.getId())) continue;
            return ecuSwitch;
        }
        for (ExternalData externalData : this.externals) {
            if (!string.equals(externalData.getId())) continue;
            return externalData;
        }
        LOGGER.warn((Object)("Logger data not found for id: " + string));
        return null;
    }

    private void addComponent(JPanel jPanel, GridBagLayout gridBagLayout, JComponent jComponent, int n) {
        this.add(jPanel, gridBagLayout, jComponent, 0, n, 3, 2);
    }

    private void addMinMaxFilter(JPanel jPanel, GridBagLayout gridBagLayout, String string, JTextField jTextField, JTextField jTextField2, int n) {
        this.add(jPanel, gridBagLayout, new JLabel(string), 0, n, 3, 2);
        this.add(jPanel, gridBagLayout, jTextField, 0, ++n, 1, 0);
        this.add(jPanel, gridBagLayout, new JLabel(" - "), 1, n, 1, 0);
        this.add(jPanel, gridBagLayout, jTextField2, 2, n, 1, 0);
    }

    private GridBagConstraints buildBaseConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        return gridBagConstraints;
    }

    private void updateConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
        gridBagConstraints.fill = n7;
    }

    private JButton buildResetButton() {
        JButton jButton = new JButton("Reset Data");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MafControlPanel.this.chartPanel.clear();
                MafControlPanel.this.parent.repaint();
            }
        });
        return jButton;
    }

    private JButton buildInterpolateButton(final JComboBox jComboBox) {
        JButton jButton = new JButton("Interpolate");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MafControlPanel.this.chartPanel.interpolate((Integer)jComboBox.getSelectedItem());
                MafControlPanel.this.parent.repaint();
            }
        });
        return jButton;
    }

    private JComboBox buildPolyOrderComboBox() {
        JComboBox<Object> jComboBox = new JComboBox<Object>(new Object[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20});
        jComboBox.setSelectedItem(10);
        return jComboBox;
    }

    private JButton buildUpdateMafButton() {
        JButton jButton = new JButton("Update MAF");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (MafControlPanel.this.showUpdateMafConfirmation() == 0) {
                        Table2D table2D = MafControlPanel.this.getMafTable(MafControlPanel.this.ecuEditor);
                        if (table2D != null) {
                            if (MafControlPanel.this.isValidRange(MafControlPanel.this.mafvMin, MafControlPanel.this.mafvMax)) {
                                DataCell[] dataCellArray;
                                DataCell[] dataCellArray2 = table2D.getAxis().getData();
                                double[] dArray = new double[dataCellArray2.length];
                                for (int i = 0; i < dataCellArray2.length; ++i) {
                                    dataCellArray = dataCellArray2[i];
                                    dArray[i] = dataCellArray.getValue();
                                }
                                double[] dArray2 = MafControlPanel.this.chartPanel.calculate(dArray);
                                dataCellArray = table2D.getData();
                                for (int i = 0; i < dataCellArray.length; ++i) {
                                    if (!MafControlPanel.this.inRange(dataCellArray2[i].getValue(), MafControlPanel.this.mafvMin, MafControlPanel.this.mafvMax)) continue;
                                    DataCell dataCell = dataCellArray[i];
                                    double d = dataCell.getValue();
                                    dataCell.setRealValue("" + d * (1.0 + dArray2[i] / 100.0));
                                }
                                table2D.colorize();
                            } else {
                                JOptionPane.showMessageDialog(MafControlPanel.this.parent, "Invalid MAFv range specified.", "Error", 0);
                            }
                        } else {
                            JOptionPane.showMessageDialog(MafControlPanel.this.parent, "Error finding MAF Sensor Scaling table.", "Error", 0);
                        }
                    }
                }
                catch (Exception exception) {
                    String string = exception.getMessage() != null && exception.getMessage().length() > 0 ? exception.getMessage() : "Unknown";
                    JOptionPane.showMessageDialog(MafControlPanel.this.parent, "Error: " + string, "Error", 0);
                }
            }
        });
        return jButton;
    }

    private boolean areNumbers(JTextField ... jTextFieldArray) {
        for (JTextField jTextField : jTextFieldArray) {
            if (this.isNumber(jTextField)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidRange(JTextField jTextField, JTextField jTextField2) {
        return this.areNumbers(jTextField, jTextField2) && this.parseDouble(jTextField) < this.parseDouble(jTextField2);
    }

    private boolean isNumber(JTextField jTextField) {
        try {
            this.parseDouble(jTextField);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean inRange(double d, double d2, double d3) {
        return d >= d2 && d <= d3;
    }

    private boolean inRange(double d, JTextField jTextField, JTextField jTextField2) {
        return this.inRange(d, this.parseDouble(jTextField), this.parseDouble(jTextField2));
    }

    private double parseDouble(JTextField jTextField) {
        return Double.parseDouble(jTextField.getText().trim());
    }

    private int showUpdateMafConfirmation() {
        return JOptionPane.showConfirmDialog(this.parent, "Update MAF Sensor Scaling table?", "Confirm Update", 0, 2);
    }

    private Table2D getMafTable(ECUEditor eCUEditor) {
        return (Table2D)this.getTable(eCUEditor, "MAF Sensor Scaling");
    }

    private <T extends Table> T getTable(ECUEditor eCUEditor, String string) {
        try {
            Rom rom = eCUEditor.getLastSelectedRom();
            return (T)TableFinder.findTableStartsWith(rom, string);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("Error getting " + string + " table"), (Throwable)exception);
            return null;
        }
    }

    public void setEcuParams(List<EcuParameter> list) {
        this.params = new ArrayList<EcuParameter>(list);
    }

    public void setEcuSwitches(List<EcuSwitch> list) {
        this.switches = new ArrayList<EcuSwitch>(list);
    }

    public void setExternalDatas(List<ExternalData> list) {
        this.externals = new ArrayList<ExternalData>(list);
    }
}

