/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.handler.file;

import com.romraider.Settings;
import com.romraider.logger.ecu.comms.query.Response;
import com.romraider.logger.ecu.definition.ConvertorUpdateListener;
import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.logger.ecu.ui.MessageListener;
import com.romraider.logger.ecu.ui.StatusChangeListener;
import com.romraider.logger.ecu.ui.handler.file.FileLogger;
import com.romraider.logger.ecu.ui.handler.file.FileLoggerImpl;
import com.romraider.logger.ecu.ui.handler.file.FileUpdateHandler;
import com.romraider.util.ParamChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FileUpdateHandlerImpl
implements FileUpdateHandler,
ConvertorUpdateListener {
    private final Map<LoggerData, Integer> loggerDatas = Collections.synchronizedMap(new LinkedHashMap());
    private final List<StatusChangeListener> listeners = Collections.synchronizedList(new ArrayList());
    private final FileLogger fileLogger;
    private Line currentLine = new Line(this.loggerDatas.keySet());

    public FileUpdateHandlerImpl(Settings settings, MessageListener messageListener) {
        this.fileLogger = new FileLoggerImpl(settings, messageListener);
    }

    public synchronized void addListener(StatusChangeListener statusChangeListener) {
        ParamChecker.checkNotNull((Object)statusChangeListener, "listener");
        this.listeners.add(statusChangeListener);
    }

    public synchronized void registerData(LoggerData loggerData) {
        if (this.loggerDatas.keySet().contains(loggerData)) {
            this.loggerDatas.put(loggerData, this.loggerDatas.get(loggerData) + 1);
        } else {
            this.loggerDatas.put(loggerData, 1);
            this.resetLine();
            this.writeHeaders();
        }
    }

    public synchronized void handleDataUpdate(Response response) {
        if (this.fileLogger.isStarted()) {
            for (LoggerData loggerData : response.getData()) {
                this.currentLine.updateParamValue(loggerData, loggerData.getSelectedConvertor().format(response.getDataValue(loggerData)));
            }
            if (this.currentLine.isFull()) {
                this.fileLogger.writeLine(this.currentLine.values(), response.getTimestamp());
                this.resetLine();
            }
        }
    }

    public synchronized void deregisterData(LoggerData loggerData) {
        if (this.loggerDatas.keySet().contains(loggerData) && this.loggerDatas.get(loggerData) > 1) {
            this.loggerDatas.put(loggerData, this.loggerDatas.get(loggerData) - 1);
        } else {
            this.loggerDatas.remove(loggerData);
            this.resetLine();
            this.writeHeaders();
        }
    }

    public synchronized void cleanUp() {
        if (this.fileLogger.isStarted()) {
            this.fileLogger.stop();
        }
    }

    public synchronized void reset() {
    }

    public synchronized void notifyConvertorUpdate(LoggerData loggerData) {
        this.resetLine();
        this.writeHeaders();
    }

    public synchronized void start() {
        if (!this.fileLogger.isStarted()) {
            this.fileLogger.start();
            this.notifyListeners(true);
            this.writeHeaders();
        }
    }

    public synchronized void stop() {
        if (this.fileLogger.isStarted()) {
            this.fileLogger.stop();
            this.notifyListeners(false);
        }
    }

    private void resetLine() {
        this.currentLine = new Line(this.loggerDatas.keySet());
    }

    private void writeHeaders() {
        if (this.fileLogger.isStarted()) {
            this.fileLogger.writeHeaders(this.currentLine.headers());
        }
    }

    private void notifyListeners(boolean bl) {
        for (StatusChangeListener statusChangeListener : this.listeners) {
            if (bl) {
                statusChangeListener.loggingData();
                continue;
            }
            statusChangeListener.readingData();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Line {
        private static final char DELIMITER = ',';
        private final Map<LoggerData, String> loggerDataValues = new LinkedHashMap<LoggerData, String>();

        public Line(Set<LoggerData> set) {
            for (LoggerData loggerData : set) {
                this.loggerDataValues.put(loggerData, null);
            }
        }

        public synchronized void updateParamValue(LoggerData loggerData, String string) {
            if (this.loggerDataValues.containsKey(loggerData)) {
                this.loggerDataValues.put(loggerData, string);
            }
        }

        public synchronized boolean isFull() {
            for (LoggerData loggerData : this.loggerDataValues.keySet()) {
                if (this.loggerDataValues.get(loggerData) != null) continue;
                return false;
            }
            return true;
        }

        public synchronized String headers() {
            StringBuilder stringBuilder = new StringBuilder();
            for (LoggerData loggerData : this.loggerDataValues.keySet()) {
                stringBuilder.append(',').append(loggerData.getName()).append(" (").append(loggerData.getSelectedConvertor().getUnits()).append(')');
            }
            return stringBuilder.toString();
        }

        public synchronized String values() {
            StringBuilder stringBuilder = new StringBuilder();
            for (LoggerData loggerData : this.loggerDataValues.keySet()) {
                String string = this.loggerDataValues.get(loggerData);
                stringBuilder.append(',').append(string);
            }
            return stringBuilder.toString();
        }
    }
}

