/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.handler.dash;

import com.romraider.logger.ecu.comms.query.Response;
import com.romraider.logger.ecu.definition.ConvertorUpdateListener;
import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.logger.ecu.ui.handler.DataUpdateHandler;
import com.romraider.logger.ecu.ui.handler.dash.DialGaugeStyle;
import com.romraider.logger.ecu.ui.handler.dash.Gauge;
import com.romraider.logger.ecu.ui.handler.dash.GaugeStyle;
import com.romraider.logger.ecu.ui.handler.dash.NoFrillsGaugeStyle;
import com.romraider.logger.ecu.ui.handler.dash.PlainGaugeStyle;
import com.romraider.logger.ecu.ui.handler.dash.SmallDialGaugeStyle;
import com.romraider.logger.ecu.ui.handler.dash.SmallGaugeStyle;
import com.romraider.util.ThreadUtil;
import java.awt.Container;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DashboardUpdateHandler
implements DataUpdateHandler,
ConvertorUpdateListener {
    private static final Class[] STYLES = new Class[]{PlainGaugeStyle.class, SmallGaugeStyle.class, NoFrillsGaugeStyle.class, DialGaugeStyle.class, SmallDialGaugeStyle.class};
    private final Map<LoggerData, Gauge> gauges = Collections.synchronizedMap(new HashMap());
    private final JPanel dashboardPanel;
    private int styleIndex;

    public DashboardUpdateHandler(JPanel jPanel) {
        this.dashboardPanel = jPanel;
    }

    @Override
    public synchronized void registerData(LoggerData loggerData) {
        GaugeStyle gaugeStyle = this.getGaugeStyle(STYLES[this.styleIndex], loggerData);
        Gauge gauge = new Gauge(gaugeStyle);
        this.gauges.put(loggerData, gauge);
        this.dashboardPanel.add(gauge);
        this.repaintDashboardPanel();
    }

    @Override
    public synchronized void handleDataUpdate(Response response) {
        for (LoggerData loggerData : response.getData()) {
            Gauge gauge = this.gauges.get(loggerData);
            if (gauge == null) continue;
            double d = response.getDataValue(loggerData);
            gauge.updateValue(d);
        }
    }

    @Override
    public synchronized void deregisterData(LoggerData loggerData) {
        this.dashboardPanel.remove(this.gauges.get(loggerData));
        this.gauges.remove(loggerData);
        this.repaintDashboardPanel();
    }

    @Override
    public synchronized void cleanUp() {
    }

    @Override
    public synchronized void reset() {
        for (Gauge gauge : this.gauges.values()) {
            gauge.resetValue();
        }
    }

    @Override
    public synchronized void notifyConvertorUpdate(LoggerData loggerData) {
        Gauge gauge = this.gauges.get(loggerData);
        if (gauge != null) {
            gauge.resetValue();
            gauge.refreshTitle();
        }
    }

    public synchronized void toggleGaugeStyle() {
        Class<? extends GaugeStyle> clazz = this.getNextStyleClass();
        for (Map.Entry<LoggerData, Gauge> entry : this.gauges.entrySet()) {
            GaugeStyle gaugeStyle = this.getGaugeStyle(clazz, entry.getKey());
            entry.getValue().setGaugeStyle(gaugeStyle);
        }
        this.repaintDashboardPanel();
    }

    private Class<? extends GaugeStyle> getNextStyleClass() {
        this.styleIndex = this.styleIndex == STYLES.length - 1 ? 0 : this.styleIndex + 1;
        return STYLES[this.styleIndex];
    }

    private GaugeStyle getGaugeStyle(Class<? extends GaugeStyle> clazz, LoggerData loggerData) {
        try {
            Constructor<? extends GaugeStyle> constructor = clazz.getDeclaredConstructor(LoggerData.class);
            return constructor.newInstance(loggerData);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    private void repaintDashboardPanel() {
        ThreadUtil.run(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Container container = DashboardUpdateHandler.this.dashboardPanel.getParent();
                        if (container != null) {
                            container.validate();
                        } else {
                            DashboardUpdateHandler.this.dashboardPanel.validate();
                        }
                        DashboardUpdateHandler.this.dashboardPanel.repaint();
                    }
                });
            }
        });
    }
}

