/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.handler;

import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.logger.ecu.ui.handler.DataUpdateHandler;
import com.romraider.logger.ecu.ui.handler.DataUpdateHandlerManager;
import java.util.ArrayList;
import java.util.List;

public final class DataUpdateHandlerManagerImpl
implements DataUpdateHandlerManager {
    private final List<DataUpdateHandler> handlers = new ArrayList<DataUpdateHandler>();

    public synchronized void addHandler(DataUpdateHandler dataUpdateHandler) {
        this.handlers.add(dataUpdateHandler);
    }

    public synchronized void registerData(LoggerData loggerData) {
        for (DataUpdateHandler dataUpdateHandler : this.handlers) {
            dataUpdateHandler.registerData(loggerData);
        }
    }

    public synchronized void deregisterData(LoggerData loggerData) {
        for (DataUpdateHandler dataUpdateHandler : this.handlers) {
            dataUpdateHandler.deregisterData(loggerData);
        }
    }

    public synchronized void cleanUp() {
        for (DataUpdateHandler dataUpdateHandler : this.handlers) {
            dataUpdateHandler.cleanUp();
        }
    }

    public synchronized void reset() {
        for (DataUpdateHandler dataUpdateHandler : this.handlers) {
            dataUpdateHandler.reset();
        }
    }
}

