/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.definition;

import com.romraider.logger.ecu.definition.EcuDataConvertor;
import com.romraider.logger.ecu.definition.EcuDataType;
import com.romraider.logger.ecu.definition.ExternalData;
import com.romraider.logger.ecu.definition.xml.ConverterMaxMinDefaults;
import com.romraider.logger.ecu.external.ExternalDataItem;
import com.romraider.logger.ecu.external.ExternalDataSource;
import com.romraider.logger.ecu.ui.handler.dash.GaugeMinMax;
import com.romraider.util.ParamChecker;
import java.text.DecimalFormat;

public final class ExternalDataImpl
implements ExternalData {
    private final EcuDataConvertor[] convertors = new EcuDataConvertor[1];
    private final ExternalDataItem dataItem;
    private final ExternalDataSource dataSource;
    private final String id;
    private boolean selected;

    public ExternalDataImpl(final ExternalDataItem externalDataItem, ExternalDataSource externalDataSource) {
        ParamChecker.checkNotNull(externalDataItem, externalDataSource);
        this.dataItem = externalDataItem;
        this.dataSource = externalDataSource;
        this.id = this.createId(externalDataItem);
        this.convertors[0] = new EcuDataConvertor(){
            private static final String FORMAT = "0.##";
            private DecimalFormat format = new DecimalFormat("0.##");

            public double convert(byte[] byArray) {
                return externalDataItem.getData();
            }

            public String format(double d) {
                return this.format.format(d);
            }

            public String getUnits() {
                return externalDataItem.getUnits();
            }

            public GaugeMinMax getGaugeMinMax() {
                return ConverterMaxMinDefaults.getMaxMin(this.getUnits());
            }

            public String getFormat() {
                return FORMAT;
            }
        };
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.dataItem.getName();
    }

    public String getDescription() {
        return this.dataItem.getDescription();
    }

    public EcuDataConvertor getSelectedConvertor() {
        return this.convertors[0];
    }

    public EcuDataConvertor[] getConvertors() {
        return this.convertors;
    }

    public void selectConvertor(EcuDataConvertor ecuDataConvertor) {
    }

    public EcuDataType getDataType() {
        return EcuDataType.EXTERNAL;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.updateConnection(bl);
    }

    private String createId(ExternalDataItem externalDataItem) {
        return "X_" + externalDataItem.getName().replaceAll(" ", "_");
    }

    private void updateConnection(boolean bl) {
        if (bl) {
            this.dataSource.connect();
        } else {
            this.dataSource.disconnect();
        }
    }
}

