/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class Binomial
extends PostfixMathCommand {
    static final int initN = 20;
    static int[][] coeffs = new int[21][];

    static void expand(int n) {
        int n2;
        int n3 = coeffs.length - 1;
        if (n <= n3) {
            return;
        }
        int[][] nArrayArray = new int[n + 1][];
        for (n2 = 0; n2 <= n3; ++n2) {
            nArrayArray[n2] = coeffs[n2];
        }
        for (n2 = n3 + 1; n2 <= n; ++n2) {
            nArrayArray[n2] = new int[n2 + 1];
            nArrayArray[n2][0] = 1;
            nArrayArray[n2][n2] = 1;
            for (int i = 1; i < n2; ++i) {
                nArrayArray[n2][i] = nArrayArray[n2 - 1][i - 1] + nArrayArray[n2 - 1][i];
            }
        }
        coeffs = nArrayArray;
    }

    public Binomial() {
        Binomial.coeffs[0] = new int[1];
        Binomial.coeffs[0][0] = 1;
        Binomial.coeffs[1] = new int[2];
        Binomial.coeffs[1][0] = 1;
        Binomial.coeffs[1][1] = 1;
        for (int i = 2; i <= 20; ++i) {
            Binomial.coeffs[i] = new int[i + 1];
            Binomial.coeffs[i][0] = 1;
            Binomial.coeffs[i][i] = 1;
            for (int j = 1; j < i; ++j) {
                Binomial.coeffs[i][j] = coeffs[i - 1][j - 1] + coeffs[i - 1][j];
            }
        }
        this.numberOfParameters = 2;
    }

    public void run(Stack stack) throws ParseException {
        Object e = stack.pop();
        Object e2 = stack.pop();
        if (!(e instanceof Number) || !(e2 instanceof Number)) {
            throw new ParseException("Binomial: both arguments must be integers. They are " + e2 + "(" + e2.getClass().getName() + ") and " + e + "(" + e2.getClass().getName() + ")");
        }
        int n = ((Number)e).intValue();
        int n2 = ((Number)e2).intValue();
        if (n2 < 0 || n < 0 || n > n2) {
            throw new ParseException("Binomial: illegal values for arguments 0<i<n. They are " + e2 + " and " + e);
        }
        Binomial.expand(n2);
        int n3 = coeffs[n2][n];
        stack.push(new Integer(n3));
    }

    public static int binom(int n, int n2) throws ArrayIndexOutOfBoundsException {
        Binomial.expand(n);
        return coeffs[n][n2];
    }
}

